/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.CryptographicKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePrivateKey;
import io.olvid.engine.encoder.Encoded;
import java.util.HashMap;

public abstract class PrivateKey
extends CryptographicKey {
    public PrivateKey(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        super(algorithmClass, algorithmImplementation, key);
    }

    public static PrivateKey of(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmClass) {
            case 18: {
                return EncryptionPrivateKey.of(algorithmImplementation, key);
            }
            case 17: {
                return SignaturePrivateKey.of(algorithmImplementation, key);
            }
            case 20: {
                return ServerAuthenticationPrivateKey.of(algorithmImplementation, key);
            }
        }
        return null;
    }
}

