/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.datatypes.key.asymmetric.PrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.PublicKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaCurve25519KeyPair;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaCurve25519PrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaCurve25519PublicKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaMDCKeyPair;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaMDCPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaMDCPublicKey;

public class KeyPair {
    protected final PublicKey publicKey;
    protected final PrivateKey privateKey;

    public KeyPair(PublicKey publicKey, PrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public static boolean areKeysMatching(PublicKey publicKey, PrivateKey privateKey) throws Exception {
        if (publicKey.getAlgorithmClass() != privateKey.getAlgorithmClass() || publicKey.getAlgorithmImplementation() != privateKey.getAlgorithmImplementation()) {
            return false;
        }
        switch (publicKey.getAlgorithmClass()) {
            case 20: {
                switch (publicKey.getAlgorithmImplementation()) {
                    case 0: {
                        return ServerAuthenticationECSdsaMDCKeyPair.areKeysMatching((ServerAuthenticationECSdsaMDCPublicKey)publicKey, (ServerAuthenticationECSdsaMDCPrivateKey)privateKey);
                    }
                    case 1: {
                        return ServerAuthenticationECSdsaCurve25519KeyPair.areKeysMatching((ServerAuthenticationECSdsaCurve25519PublicKey)publicKey, (ServerAuthenticationECSdsaCurve25519PrivateKey)privateKey);
                    }
                }
                break;
            }
        }
        throw new Exception("Keys match check not implemented");
    }
}

