/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesCurve25519PrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesMDCPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.PrivateKey;
import io.olvid.engine.encoder.Encoded;
import java.security.InvalidParameterException;
import java.util.HashMap;

public abstract class EncryptionPrivateKey
extends PrivateKey {
    public EncryptionPrivateKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) throws InvalidParameterException {
        super((byte)18, algorithmImplementation, key);
    }

    public static EncryptionPrivateKey of(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmImplementation) {
            case 0: {
                return new EncryptionEciesMDCPrivateKey(key);
            }
            case 1: {
                return new EncryptionEciesCurve25519PrivateKey(key);
            }
        }
        return null;
    }
}

