/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.crypto.EdwardCurve;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.EdwardCurvePoint;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesCurve25519PrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesCurve25519PublicKey;
import io.olvid.engine.datatypes.key.asymmetric.KeyPair;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.encoder.EncodingException;
import java.math.BigInteger;
import java.util.HashMap;

public class EncryptionEciesCurve25519KeyPair
extends KeyPair {
    @Override
    public EncryptionEciesCurve25519PublicKey getPublicKey() {
        return (EncryptionEciesCurve25519PublicKey)this.publicKey;
    }

    @Override
    public EncryptionEciesCurve25519PrivateKey getPrivateKey() {
        return (EncryptionEciesCurve25519PrivateKey)this.privateKey;
    }

    public EncryptionEciesCurve25519KeyPair(EncryptionEciesCurve25519PublicKey publicKey, EncryptionEciesCurve25519PrivateKey privateKey) {
        super(publicKey, privateKey);
    }

    public static EncryptionEciesCurve25519KeyPair generate(PRNG prng) {
        EdwardCurvePoint A;
        BigInteger a;
        EdwardCurve curve25519 = Suite.getCurve("Curve_25519");
        while ((a = prng.bigInt(curve25519.q)).equals(BigInteger.ZERO) || a.equals(BigInteger.ONE) || (A = curve25519.scalarMultiplicationWithX(a, curve25519.G)).isLowOrderPoint()) {
        }
        HashMap<DictionaryKey, Encoded> publicKeyDictionary = new HashMap<DictionaryKey, Encoded>();
        HashMap<DictionaryKey, Encoded> privateKeyDictionary = new HashMap<DictionaryKey, Encoded>();
        try {
            publicKeyDictionary.put(new DictionaryKey("x"), Encoded.of(A.getX(), curve25519.byteLength));
            publicKeyDictionary.put(new DictionaryKey("y"), Encoded.of(A.getY(), curve25519.byteLength));
            privateKeyDictionary.put(new DictionaryKey("n"), Encoded.of(a, curve25519.byteLength));
        }
        catch (EncodingException e) {
            return null;
        }
        return new EncryptionEciesCurve25519KeyPair(new EncryptionEciesCurve25519PublicKey(publicKeyDictionary), new EncryptionEciesCurve25519PrivateKey(privateKeyDictionary));
    }
}

