/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPublicKey;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.HashMap;
import java.util.Map;

public class ServerQuery {
    private final Identity ownedIdentity;
    private final Type type;
    private final Encoded encodedElements;
    private Encoded encodedResponse;

    public ServerQuery(Encoded encodedElements, Identity ownedIdentity, Type type) {
        this.ownedIdentity = ownedIdentity;
        this.type = type;
        this.encodedElements = encodedElements;
        this.encodedResponse = null;
    }

    public boolean isWebSocket() {
        return this.type.isWebSocket();
    }

    public static ServerQuery of(Encoded encoded) throws DecodingException {
        Encoded[] list = encoded.decodeList();
        if (list.length != 3) {
            throw new DecodingException();
        }
        return new ServerQuery(list[0], list[1].decodeIdentity(), Type.of(list[2]));
    }

    public Encoded encode() {
        return Encoded.of(new Encoded[]{this.encodedElements, Encoded.of(this.ownedIdentity), this.type.encode()});
    }

    public void setResponse(Encoded encodedResponse) {
        this.encodedResponse = encodedResponse;
    }

    public Type getType() {
        return this.type;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public Encoded getEncodedElements() {
        return this.encodedElements;
    }

    public Encoded getEncodedResponse() {
        return this.encodedResponse;
    }

    public static abstract class Type {
        public abstract TypeId getId();

        abstract String getServer();

        abstract Encoded[] getEncodedParts();

        abstract boolean isWebSocket();

        public static Type of(Encoded encoded) throws DecodingException {
            Encoded[] list = encoded.decodeList();
            if (list.length != 3) {
                throw new DecodingException();
            }
            int id = (int)list[0].decodeLong();
            String server = list[1].decodeString();
            Encoded[] encodedParts = list[2].decodeList();
            TypeId typeId = TypeId.fromIntValue(id);
            if (typeId == null) {
                throw new DecodingException();
            }
            switch (typeId.ordinal()) {
                case 0: {
                    return new DeviceDiscoveryQuery(server, encodedParts);
                }
                case 1: {
                    return new PutUserDataQuery(server, encodedParts);
                }
                case 2: {
                    return new GetUserDataQuery(server, encodedParts);
                }
                case 3: {
                    return new CheckKeycloakRevocationQuery(server, encodedParts);
                }
                case 4: {
                    return new CreateGroupBlobQuery(server, encodedParts);
                }
                case 5: {
                    return new GetGroupBlobQuery(server, encodedParts);
                }
                case 6: {
                    return new LockGroupBlobQuery(server, encodedParts);
                }
                case 7: {
                    return new UpdateGroupBlobQuery(server, encodedParts);
                }
                case 8: {
                    return new PutGroupLogQuery(server, encodedParts);
                }
                case 9: {
                    return new DeleteGroupBlobQuery(server, encodedParts);
                }
                case 10: {
                    return new GetKeycloakDataQuery(server, encodedParts);
                }
                case 11: {
                    return new OwnedDeviceDiscoveryQuery(server, encodedParts);
                }
                case 12: {
                    return new DeviceManagementSetNicknameQuery(server, encodedParts);
                }
                case 13: {
                    return new DeviceManagementDeactivateDeviceQuery(server, encodedParts);
                }
                case 14: {
                    return new DeviceManagementSetUnexpiringDeviceQuery(server, encodedParts);
                }
                case 15: {
                    return new RegisterApiKeyQuery(server, encodedParts);
                }
                case 16: {
                    return new UploadPreKeyQuery(server, encodedParts);
                }
                case 17: {
                    return new TransferSourceQuery(encodedParts);
                }
                case 18: {
                    return new TransferTargetQuery(encodedParts);
                }
                case 19: {
                    return new TransferRelayQuery(encodedParts);
                }
                case 20: {
                    return new TransferWaitQuery(encodedParts);
                }
                case 21: {
                    return new TransferCloseQuery(encodedParts);
                }
            }
            throw new DecodingException();
        }

        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.getId().value), Encoded.of(this.getServer()), Encoded.of(this.getEncodedParts())});
        }
    }

    public static class BackupsV2DownloadProfilePictureQuery
    extends Type {
        public final Identity identity;
        public final UID photoLabel;
        public final AuthEncKey photoKey;

        public BackupsV2DownloadProfilePictureQuery(Identity identity, UID photoLabel, AuthEncKey photoKey) {
            this.identity = identity;
            this.photoLabel = photoLabel;
            this.photoKey = photoKey;
        }

        @Override
        public TypeId getId() {
            return TypeId.BACKUPS_V2_DOWNLOAD_PROFILE_PICTURE_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.identity.getServer();
        }

        @Override
        Encoded[] getEncodedParts() {
            throw new RuntimeException("BackupsV2 server queries cannot be encoded.");
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class BackupsV2ListBackupsQuery
    extends Type {
        public final String server;
        public final UID backupUid;

        public BackupsV2ListBackupsQuery(String server, UID backupUid) {
            this.server = server;
            this.backupUid = backupUid;
        }

        @Override
        public TypeId getId() {
            return TypeId.BACKUPS_V2_LIST_BACKUPS_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            throw new RuntimeException("BackupsV2 server queries cannot be encoded.");
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class BackupsV2DeleteBackupQuery
    extends Type {
        public final String server;
        public final UID backupUid;
        public final UID threadId;
        public final long version;
        public final byte[] signature;

        public BackupsV2DeleteBackupQuery(String server, UID backupUid, UID threadId, long version, byte[] signature) {
            this.server = server;
            this.backupUid = backupUid;
            this.threadId = threadId;
            this.version = version;
            this.signature = signature;
        }

        @Override
        public TypeId getId() {
            return TypeId.BACKUPS_V2_DELETE_BACKUP_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            throw new RuntimeException("BackupsV2 server queries cannot be encoded.");
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class BackupsV2UploadBackupQuery
    extends Type {
        public final String server;
        public final UID backupUid;
        public final UID threadId;
        public final long version;
        public final EncryptedBytes encryptedBackup;
        public final byte[] signature;

        public BackupsV2UploadBackupQuery(String server, UID backupUid, UID threadId, long version, EncryptedBytes encryptedBackup, byte[] signature) {
            this.server = server;
            this.backupUid = backupUid;
            this.threadId = threadId;
            this.version = version;
            this.encryptedBackup = encryptedBackup;
            this.signature = signature;
        }

        @Override
        public TypeId getId() {
            return TypeId.BACKUPS_V2_UPLOAD_BACKUP_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            throw new RuntimeException("BackupsV2 server queries cannot be encoded.");
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class BackupsV2CreateBackupQuery
    extends Type {
        public final String server;
        public final UID backupUid;
        public final ServerAuthenticationPublicKey serverAuthenticationPublicKey;

        public BackupsV2CreateBackupQuery(String server, UID backupUid, ServerAuthenticationPublicKey serverAuthenticationPublicKey) {
            this.server = server;
            this.backupUid = backupUid;
            this.serverAuthenticationPublicKey = serverAuthenticationPublicKey;
        }

        @Override
        public TypeId getId() {
            return TypeId.BACKUPS_V2_CREATE_BACKUP_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            throw new RuntimeException("BackupsV2 server queries cannot be encoded.");
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class TransferCloseQuery
    extends Type {
        public final boolean abort;

        public TransferCloseQuery(boolean abort) {
            this.abort = abort;
        }

        public TransferCloseQuery(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 1) {
                throw new DecodingException();
            }
            this.abort = encodedParts[0].decodeBoolean();
        }

        @Override
        public TypeId getId() {
            return TypeId.TRANSFER_CLOSE_QUERY_ID;
        }

        @Override
        String getServer() {
            return "";
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.abort)};
        }

        @Override
        boolean isWebSocket() {
            return true;
        }
    }

    public static class TransferWaitQuery
    extends Type {
        public TransferWaitQuery() {
        }

        public TransferWaitQuery(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 0) {
                throw new DecodingException();
            }
        }

        @Override
        public TypeId getId() {
            return TypeId.TRANSFER_WAIT_QUERY_ID;
        }

        @Override
        String getServer() {
            return "";
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[0];
        }

        @Override
        boolean isWebSocket() {
            return true;
        }
    }

    public static class TransferRelayQuery
    extends Type {
        public final String connectionIdentifier;
        public final byte[] payload;
        public final boolean noResponseExpected;

        public TransferRelayQuery(String connectionIdentifier, byte[] payload, boolean noResponseExpected) {
            this.connectionIdentifier = connectionIdentifier;
            this.payload = payload;
            this.noResponseExpected = noResponseExpected;
        }

        public TransferRelayQuery(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 3) {
                throw new DecodingException();
            }
            this.connectionIdentifier = encodedParts[0].decodeString();
            this.payload = encodedParts[1].decodeBytes();
            this.noResponseExpected = encodedParts[2].decodeBoolean();
        }

        @Override
        public TypeId getId() {
            return TypeId.TRANSFER_RELAY_QUERY_ID;
        }

        @Override
        String getServer() {
            return "";
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.connectionIdentifier), Encoded.of(this.payload), Encoded.of(this.noResponseExpected)};
        }

        @Override
        boolean isWebSocket() {
            return true;
        }
    }

    public static class TransferTargetQuery
    extends Type {
        public final long sessionNumber;
        public final byte[] payload;

        public TransferTargetQuery(long sessionNumber, byte[] payload) {
            this.sessionNumber = sessionNumber;
            this.payload = payload;
        }

        public TransferTargetQuery(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 2) {
                throw new DecodingException();
            }
            this.sessionNumber = encodedParts[0].decodeLong();
            this.payload = encodedParts[1].decodeBytes();
        }

        @Override
        public TypeId getId() {
            return TypeId.TRANSFER_TARGET_QUERY_ID;
        }

        @Override
        String getServer() {
            return "";
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.sessionNumber), Encoded.of(this.payload)};
        }

        @Override
        boolean isWebSocket() {
            return true;
        }
    }

    public static class TransferSourceQuery
    extends Type {
        public TransferSourceQuery() {
        }

        public TransferSourceQuery(Encoded[] encodedParts) throws DecodingException {
            if (encodedParts.length != 0) {
                throw new DecodingException();
            }
        }

        @Override
        public TypeId getId() {
            return TypeId.TRANSFER_SOURCE_QUERY_ID;
        }

        @Override
        String getServer() {
            return "";
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[0];
        }

        @Override
        boolean isWebSocket() {
            return true;
        }
    }

    public static class UploadPreKeyQuery
    extends Type {
        public final String server;
        public final UID deviceUid;
        public final byte[] preKeyBytes;

        public UploadPreKeyQuery(Identity ownedIdentity, UID deviceUid, byte[] preKeyBytes) {
            this.server = ownedIdentity.getServer();
            this.deviceUid = deviceUid;
            this.preKeyBytes = preKeyBytes;
        }

        public UploadPreKeyQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length != 2) {
                throw new DecodingException();
            }
            this.deviceUid = encodedParts[0].decodeUid();
            this.preKeyBytes = encodedParts[1].decodeBytes();
        }

        @Override
        public TypeId getId() {
            return TypeId.UPLOAD_PRE_KEY_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.deviceUid), Encoded.of(this.preKeyBytes)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class RegisterApiKeyQuery
    extends Type {
        public final String server;
        public final String apiKeyString;
        public final byte[] serverSessionToken;

        public RegisterApiKeyQuery(Identity ownedIdentity, byte[] serverSessionToken, String apiKeyString) {
            this.server = ownedIdentity.getServer();
            this.apiKeyString = apiKeyString;
            this.serverSessionToken = serverSessionToken;
        }

        public RegisterApiKeyQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length != 2) {
                throw new DecodingException();
            }
            this.apiKeyString = encodedParts[0].decodeString();
            this.serverSessionToken = encodedParts[1].decodeBytes();
        }

        @Override
        public TypeId getId() {
            return TypeId.REGISTER_API_KEY_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.apiKeyString), Encoded.of(this.serverSessionToken)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class DeviceManagementSetUnexpiringDeviceQuery
    extends Type {
        public final String server;
        public final UID deviceUid;

        public DeviceManagementSetUnexpiringDeviceQuery(Identity ownedIdentity, UID deviceUid) {
            this.server = ownedIdentity.getServer();
            this.deviceUid = deviceUid;
        }

        public DeviceManagementSetUnexpiringDeviceQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length != 1) {
                throw new DecodingException();
            }
            this.deviceUid = encodedParts[0].decodeUid();
        }

        @Override
        public TypeId getId() {
            return TypeId.DEVICE_MANAGEMENT_SET_UNEXPIRING_DEVICE_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.deviceUid)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class DeviceManagementDeactivateDeviceQuery
    extends Type {
        public final String server;
        public final UID deviceUid;

        public DeviceManagementDeactivateDeviceQuery(Identity ownedIdentity, UID deviceUid) {
            this.server = ownedIdentity.getServer();
            this.deviceUid = deviceUid;
        }

        public DeviceManagementDeactivateDeviceQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length != 1) {
                throw new DecodingException();
            }
            this.deviceUid = encodedParts[0].decodeUid();
        }

        @Override
        public TypeId getId() {
            return TypeId.DEVICE_MANAGEMENT_DEACTIVATE_DEVICE_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.deviceUid)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class DeviceManagementSetNicknameQuery
    extends Type {
        public final String server;
        public final UID deviceUid;
        public final EncryptedBytes encryptedDeviceName;
        public final boolean isCurrentDevice;

        public DeviceManagementSetNicknameQuery(Identity ownedIdentity, UID deviceUid, EncryptedBytes encryptedDeviceName, boolean isCurrentDevice) {
            this.server = ownedIdentity.getServer();
            this.deviceUid = deviceUid;
            this.encryptedDeviceName = encryptedDeviceName;
            this.isCurrentDevice = isCurrentDevice;
        }

        public DeviceManagementSetNicknameQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length != 3) {
                throw new DecodingException();
            }
            this.deviceUid = encodedParts[0].decodeUid();
            this.encryptedDeviceName = encodedParts[1].decodeEncryptedData();
            this.isCurrentDevice = encodedParts[2].decodeBoolean();
        }

        @Override
        public TypeId getId() {
            return TypeId.DEVICE_MANAGEMENT_SET_NICKNAME_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.deviceUid), Encoded.of(this.encryptedDeviceName), Encoded.of(this.isCurrentDevice)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class OwnedDeviceDiscoveryQuery
    extends Type {
        public final String server;

        public OwnedDeviceDiscoveryQuery(Identity ownedIdentity) {
            this.server = ownedIdentity.getServer();
        }

        public OwnedDeviceDiscoveryQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length != 0 && encodedParts.length != 1) {
                throw new DecodingException();
            }
        }

        @Override
        public TypeId getId() {
            return TypeId.OWNED_DEVICE_DISCOVERY_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[0];
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class GetKeycloakDataQuery
    extends Type {
        public final String server;
        public final UID serverLabel;

        public GetKeycloakDataQuery(String serverUrl, UID serverLabel) {
            this.server = serverUrl;
            this.serverLabel = serverLabel;
        }

        public GetKeycloakDataQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length == 1) {
                this.serverLabel = encodedParts[0].decodeUid();
            } else if (encodedParts.length == 2) {
                this.serverLabel = encodedParts[1].decodeUid();
            } else {
                throw new DecodingException();
            }
        }

        @Override
        public TypeId getId() {
            return TypeId.GET_KEYCLOAK_DATA_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.serverLabel)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class DeleteGroupBlobQuery
    extends Type {
        public final String server;
        public final UID groupUid;
        public final byte[] signature;

        public DeleteGroupBlobQuery(GroupV2.Identifier groupIdentifier, byte[] signature) {
            this.server = groupIdentifier.serverUrl;
            this.groupUid = groupIdentifier.groupUid;
            this.signature = signature;
        }

        public DeleteGroupBlobQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length == 2) {
                this.groupUid = encodedParts[0].decodeUid();
                this.signature = encodedParts[1].decodeBytes();
            } else if (encodedParts.length == 3) {
                this.groupUid = encodedParts[1].decodeUid();
                this.signature = encodedParts[2].decodeBytes();
            } else {
                throw new DecodingException();
            }
        }

        @Override
        public TypeId getId() {
            return TypeId.DELETE_GROUP_BLOB_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.groupUid), Encoded.of(this.signature)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class PutGroupLogQuery
    extends Type {
        public final String server;
        public final UID groupUid;
        public final byte[] signature;

        public PutGroupLogQuery(GroupV2.Identifier groupIdentifier, byte[] signature) {
            this.server = groupIdentifier.serverUrl;
            this.groupUid = groupIdentifier.groupUid;
            this.signature = signature;
        }

        public PutGroupLogQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length == 2) {
                this.groupUid = encodedParts[0].decodeUid();
                this.signature = encodedParts[1].decodeBytes();
            } else if (encodedParts.length == 3) {
                this.groupUid = encodedParts[1].decodeUid();
                this.signature = encodedParts[2].decodeBytes();
            } else {
                throw new DecodingException();
            }
        }

        @Override
        public TypeId getId() {
            return TypeId.PUT_GROUP_LOG_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.groupUid), Encoded.of(this.signature)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class UpdateGroupBlobQuery
    extends Type {
        public final String server;
        public final UID groupUid;
        public final Encoded encodedGroupAdminPublicKey;
        public final EncryptedBytes encryptedBlob;
        public final byte[] signature;
        public final byte[] lockNonce;

        public UpdateGroupBlobQuery(GroupV2.Identifier groupIdentifier, byte[] lockNonce, EncryptedBytes encryptedBlob, Encoded encodedGroupAdminPublicKey, byte[] signature) {
            this.server = groupIdentifier.serverUrl;
            this.groupUid = groupIdentifier.groupUid;
            this.encodedGroupAdminPublicKey = encodedGroupAdminPublicKey;
            this.encryptedBlob = encryptedBlob;
            this.signature = signature;
            this.lockNonce = lockNonce;
        }

        public UpdateGroupBlobQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length == 5) {
                this.groupUid = encodedParts[0].decodeUid();
                this.encodedGroupAdminPublicKey = encodedParts[1];
                this.encryptedBlob = encodedParts[2].decodeEncryptedData();
                this.signature = encodedParts[3].decodeBytes();
                this.lockNonce = encodedParts[4].decodeBytes();
            } else if (encodedParts.length == 6) {
                this.groupUid = encodedParts[1].decodeUid();
                this.encodedGroupAdminPublicKey = encodedParts[2];
                this.encryptedBlob = encodedParts[3].decodeEncryptedData();
                this.signature = encodedParts[4].decodeBytes();
                this.lockNonce = encodedParts[5].decodeBytes();
            } else {
                throw new DecodingException();
            }
        }

        @Override
        public TypeId getId() {
            return TypeId.UPDATE_GROUP_BLOB_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.groupUid), this.encodedGroupAdminPublicKey, Encoded.of(this.encryptedBlob), Encoded.of(this.signature), Encoded.of(this.lockNonce)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class LockGroupBlobQuery
    extends Type {
        public final String server;
        public final UID groupUid;
        public final byte[] signature;
        public final byte[] lockNonce;

        public LockGroupBlobQuery(GroupV2.Identifier groupIdentifier, byte[] lockNonce, byte[] signature) {
            this.server = groupIdentifier.serverUrl;
            this.groupUid = groupIdentifier.groupUid;
            this.signature = signature;
            this.lockNonce = lockNonce;
        }

        public LockGroupBlobQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length == 3) {
                this.groupUid = encodedParts[0].decodeUid();
                this.signature = encodedParts[1].decodeBytes();
                this.lockNonce = encodedParts[2].decodeBytes();
            } else if (encodedParts.length == 4) {
                this.groupUid = encodedParts[1].decodeUid();
                this.signature = encodedParts[2].decodeBytes();
                this.lockNonce = encodedParts[3].decodeBytes();
            } else {
                throw new DecodingException();
            }
        }

        @Override
        public TypeId getId() {
            return TypeId.LOCK_GROUP_BLOB_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.groupUid), Encoded.of(this.signature), Encoded.of(this.lockNonce)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class GetGroupBlobQuery
    extends Type {
        public final String server;
        public final UID groupUid;
        public final byte[] serverQueryNonce;

        public GetGroupBlobQuery(GroupV2.Identifier groupIdentifier, byte[] serverQueryNonce) {
            this.server = groupIdentifier.serverUrl;
            this.groupUid = groupIdentifier.groupUid;
            this.serverQueryNonce = serverQueryNonce;
        }

        public GetGroupBlobQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length == 2) {
                this.groupUid = encodedParts[0].decodeUid();
                this.serverQueryNonce = encodedParts[1].decodeBytes();
            } else if (encodedParts.length == 3) {
                this.groupUid = encodedParts[1].decodeUid();
                this.serverQueryNonce = encodedParts[2].decodeBytes();
            } else {
                throw new DecodingException();
            }
        }

        @Override
        public TypeId getId() {
            return TypeId.GET_GROUP_BLOB_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.groupUid), Encoded.of(this.serverQueryNonce)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class CreateGroupBlobQuery
    extends Type {
        public final String server;
        public final UID groupUid;
        public final Encoded encodedGroupAdminPublicKey;
        public final EncryptedBytes encryptedBlob;

        public CreateGroupBlobQuery(GroupV2.Identifier groupIdentifier, Encoded encodedGroupAdminPublicKey, EncryptedBytes encryptedBlob) {
            this.server = groupIdentifier.serverUrl;
            this.groupUid = groupIdentifier.groupUid;
            this.encodedGroupAdminPublicKey = encodedGroupAdminPublicKey;
            this.encryptedBlob = encryptedBlob;
        }

        public CreateGroupBlobQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length == 3) {
                this.groupUid = encodedParts[0].decodeUid();
                this.encodedGroupAdminPublicKey = encodedParts[1];
                this.encryptedBlob = encodedParts[2].decodeEncryptedData();
            } else if (encodedParts.length == 4) {
                this.groupUid = encodedParts[1].decodeUid();
                this.encodedGroupAdminPublicKey = encodedParts[2];
                this.encryptedBlob = encodedParts[3].decodeEncryptedData();
            } else {
                throw new DecodingException();
            }
        }

        @Override
        public TypeId getId() {
            return TypeId.CREATE_GROUP_BLOB_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.groupUid), this.encodedGroupAdminPublicKey, Encoded.of(this.encryptedBlob)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class CheckKeycloakRevocationQuery
    extends Type {
        public final String server;
        public final String signedContactDetails;

        public CheckKeycloakRevocationQuery(String keycloakServerUrl, String signedContactDetails) {
            this.server = keycloakServerUrl;
            this.signedContactDetails = signedContactDetails;
        }

        public CheckKeycloakRevocationQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length == 1) {
                this.signedContactDetails = encodedParts[0].decodeString();
            } else if (encodedParts.length == 2) {
                this.signedContactDetails = encodedParts[1].decodeString();
            } else {
                throw new DecodingException();
            }
        }

        @Override
        public TypeId getId() {
            return TypeId.CHECK_KEYCLOAK_REVOCATION_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.signedContactDetails)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class GetUserDataQuery
    extends Type {
        public final String server;
        public final Identity identity;
        public final UID serverLabel;

        public GetUserDataQuery(Identity identity, UID serverLabel) {
            this.server = identity.getServer();
            this.identity = identity;
            this.serverLabel = serverLabel;
        }

        public GetUserDataQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length != 2) {
                throw new DecodingException();
            }
            this.identity = encodedParts[0].decodeIdentity();
            this.serverLabel = encodedParts[1].decodeUid();
        }

        @Override
        public TypeId getId() {
            return TypeId.GET_USER_DATA_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.identity), Encoded.of(this.serverLabel)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class PutUserDataQuery
    extends Type {
        public final String server;
        public final Identity ownedIdentity;
        public final UID serverLabel;
        public final String dataUrl;
        public final AuthEncKey dataKey;

        public PutUserDataQuery(Identity ownedIdentity, UID serverLabel, String dataUrl, AuthEncKey dataKey) {
            this.server = ownedIdentity.getServer();
            this.ownedIdentity = ownedIdentity;
            this.serverLabel = serverLabel;
            this.dataUrl = dataUrl;
            this.dataKey = dataKey;
        }

        public PutUserDataQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length != 4) {
                throw new DecodingException();
            }
            this.ownedIdentity = encodedParts[0].decodeIdentity();
            this.serverLabel = encodedParts[1].decodeUid();
            this.dataUrl = encodedParts[2].decodeString();
            this.dataKey = (AuthEncKey)encodedParts[3].decodeSymmetricKey();
        }

        @Override
        public TypeId getId() {
            return TypeId.PUT_USER_DATA_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.ownedIdentity), Encoded.of(this.serverLabel), Encoded.of(this.dataUrl), Encoded.of(this.dataKey)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static class DeviceDiscoveryQuery
    extends Type {
        public final String server;
        public final Identity identity;

        public DeviceDiscoveryQuery(Identity identity) {
            this.server = identity.getServer();
            this.identity = identity;
        }

        public DeviceDiscoveryQuery(String server, Encoded[] encodedParts) throws DecodingException {
            this.server = server;
            if (encodedParts.length != 1) {
                throw new DecodingException();
            }
            this.identity = encodedParts[0].decodeIdentity();
        }

        @Override
        public TypeId getId() {
            return TypeId.DEVICE_DISCOVERY_QUERY_ID;
        }

        @Override
        String getServer() {
            return this.server;
        }

        @Override
        Encoded[] getEncodedParts() {
            return new Encoded[]{Encoded.of(this.identity)};
        }

        @Override
        boolean isWebSocket() {
            return false;
        }
    }

    public static enum TypeId {
        DEVICE_DISCOVERY_QUERY_ID(0),
        PUT_USER_DATA_QUERY_ID(1),
        GET_USER_DATA_QUERY_ID(2),
        CHECK_KEYCLOAK_REVOCATION_QUERY_ID(3),
        CREATE_GROUP_BLOB_QUERY_ID(4),
        GET_GROUP_BLOB_QUERY_ID(5),
        LOCK_GROUP_BLOB_QUERY_ID(6),
        UPDATE_GROUP_BLOB_QUERY_ID(7),
        PUT_GROUP_LOG_QUERY_ID(8),
        DELETE_GROUP_BLOB_QUERY_ID(9),
        GET_KEYCLOAK_DATA_QUERY_ID(10),
        OWNED_DEVICE_DISCOVERY_QUERY_ID(11),
        DEVICE_MANAGEMENT_SET_NICKNAME_QUERY_ID(12),
        DEVICE_MANAGEMENT_DEACTIVATE_DEVICE_QUERY_ID(13),
        DEVICE_MANAGEMENT_SET_UNEXPIRING_DEVICE_QUERY_ID(14),
        REGISTER_API_KEY_QUERY_ID(15),
        UPLOAD_PRE_KEY_QUERY_ID(16),
        TRANSFER_SOURCE_QUERY_ID(1000),
        TRANSFER_TARGET_QUERY_ID(1001),
        TRANSFER_RELAY_QUERY_ID(1002),
        TRANSFER_WAIT_QUERY_ID(1003),
        TRANSFER_CLOSE_QUERY_ID(1004),
        BACKUPS_V2_CREATE_BACKUP_QUERY_ID(2000),
        BACKUPS_V2_UPLOAD_BACKUP_QUERY_ID(2001),
        BACKUPS_V2_DELETE_BACKUP_QUERY_ID(2002),
        BACKUPS_V2_LIST_BACKUPS_QUERY_ID(2003),
        BACKUPS_V2_DOWNLOAD_PROFILE_PICTURE_QUERY_ID(2004);

        private static final Map<Integer, TypeId> valueMap;
        final int value;

        private TypeId(int value) {
            this.value = value;
        }

        static TypeId fromIntValue(int value) {
            return valueMap.get(value);
        }

        static {
            valueMap = new HashMap<Integer, TypeId>();
            for (TypeId step : TypeId.values()) {
                valueMap.put(step.value, step);
            }
        }
    }
}

