/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.DialogType;
import io.olvid.engine.datatypes.containers.ServerQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class SendChannelInfo {
    public static final int LOCAL_TYPE = 0;
    public static final int OBLIVIOUS_CHANNEL_TYPE = 1;
    public static final int ASYMMETRIC_CHANNEL_TYPE = 2;
    public static final int ALL_CONFIRMED_OBLIVIOUS_CHANNELS_OR_PRE_KEY_ON_SAME_SERVER_TYPE = 3;
    public static final int ASYMMETRIC_BROADCAST_CHANNEL_TYPE = 4;
    public static final int USER_INTERFACE_TYPE = 5;
    public static final int SERVER_QUERY_TYPE = 6;
    public static final int ALL_OWNED_CONFIRMED_OBLIVIOUS_CHANNELS_OR_PRE_KEY_TYPE = 7;
    public static final int OBLIVIOUS_CHANNEL_OR_PRE_KEY_TYPE = 8;
    private final int channelType;
    private final Identity toIdentity;
    private final Identity fromIdentity;
    private final UID[] remoteDeviceUids;
    private final Boolean necessarilyConfirmed;
    private final DialogType dialogType;
    private final UUID dialogUuid;
    private final ServerQuery.Type serverQueryType;
    private final Identity[] toIdentities;

    private SendChannelInfo(int channelType, Identity toIdentity, Identity fromIdentity) {
        this(channelType, toIdentity, fromIdentity, null, null, null, null, null, null);
    }

    private SendChannelInfo(int channelType, Identity toIdentity, Identity fromIdentity, UID[] remoteDeviceUids, Boolean necessarilyConfirmed, DialogType dialogType, UUID dialogUuid, ServerQuery.Type serverQueryType, Identity[] toIdentities) {
        this.channelType = channelType;
        this.toIdentity = toIdentity;
        this.fromIdentity = fromIdentity;
        this.remoteDeviceUids = remoteDeviceUids;
        this.necessarilyConfirmed = necessarilyConfirmed;
        this.dialogType = dialogType;
        this.dialogUuid = dialogUuid;
        this.serverQueryType = serverQueryType;
        this.toIdentities = toIdentities;
    }

    public static SendChannelInfo createLocalChannelInfo(Identity ownedIdentity) {
        if (ownedIdentity == null) {
            return null;
        }
        return new SendChannelInfo(0, ownedIdentity, ownedIdentity);
    }

    public static SendChannelInfo createObliviousChannelInfo(Identity toIdentity, Identity fromIdentity, UID[] remoteDeviceUids, Boolean necessarilyConfirmed) {
        if (toIdentity == null || fromIdentity == null || remoteDeviceUids == null || necessarilyConfirmed == null) {
            return null;
        }
        return new SendChannelInfo(1, toIdentity, fromIdentity, remoteDeviceUids, necessarilyConfirmed, null, null, null, null);
    }

    public static SendChannelInfo createObliviousChannelOrPreKeyInfo(Identity toIdentity, Identity fromIdentity, UID[] remoteDeviceUids, Boolean necessarilyConfirmed) {
        if (toIdentity == null || fromIdentity == null || remoteDeviceUids == null || necessarilyConfirmed == null) {
            return null;
        }
        return new SendChannelInfo(8, toIdentity, fromIdentity, remoteDeviceUids, necessarilyConfirmed, null, null, null, null);
    }

    public static SendChannelInfo createAsymmetricChannelInfo(Identity toIdentity, Identity fromIdentity, UID[] remoteDeviceUids) {
        if (toIdentity == null || fromIdentity == null || remoteDeviceUids == null) {
            return null;
        }
        return new SendChannelInfo(2, toIdentity, fromIdentity, remoteDeviceUids, null, null, null, null, null);
    }

    public static SendChannelInfo createAllConfirmedObliviousChannelsOrPreKeysInfo(Identity toIdentity, Identity fromIdentity) {
        if (toIdentity == null || fromIdentity == null) {
            return null;
        }
        return new SendChannelInfo(3, null, fromIdentity, new UID[1], null, null, null, null, new Identity[]{toIdentity});
    }

    public static SendChannelInfo[] createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(Identity[] toIdentities, Identity fromIdentity) {
        return SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(toIdentities, new UID[toIdentities.length], fromIdentity);
    }

    public static SendChannelInfo[] createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(Identity[] toIdentities, UID[] toDeviceUids, Identity fromIdentity) {
        if (toIdentities == null || toIdentities.length == 0 || fromIdentity == null) {
            return null;
        }
        HashMap<String, ArrayList<Identity>> map = new HashMap<String, ArrayList<Identity>>();
        HashMap<Identity, UID> deviceUidsMap = new HashMap<Identity, UID>();
        for (int i = 0; i < toIdentities.length; ++i) {
            String server = toIdentities[i].getServer();
            ArrayList<Identity> serverIdentityList = (ArrayList<Identity>)map.get(server);
            if (serverIdentityList == null) {
                serverIdentityList = new ArrayList<Identity>();
                map.put(server, serverIdentityList);
            }
            serverIdentityList.add(toIdentities[i]);
            if (toDeviceUids[i] == null) continue;
            deviceUidsMap.put(toIdentities[i], toDeviceUids[i]);
        }
        SendChannelInfo[] sendChannelInfos = new SendChannelInfo[map.size()];
        int i = 0;
        for (String server : map.keySet()) {
            List serverIdentityList = (List)map.get(server);
            if (serverIdentityList != null && !serverIdentityList.isEmpty()) {
                Identity[] identities = new Identity[serverIdentityList.size()];
                UID[] deviceUids = new UID[serverIdentityList.size()];
                int j = 0;
                Iterator iterator = serverIdentityList.iterator();
                while (iterator.hasNext()) {
                    Identity identity;
                    identities[j] = identity = (Identity)iterator.next();
                    deviceUids[j] = (UID)deviceUidsMap.get(identity);
                    ++j;
                }
                sendChannelInfos[i] = new SendChannelInfo(3, null, fromIdentity, deviceUids, null, null, null, null, identities);
            } else {
                sendChannelInfos[i] = null;
            }
            ++i;
        }
        return sendChannelInfos;
    }

    public static SendChannelInfo createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(Identity ownedIdentity) {
        if (ownedIdentity == null) {
            return null;
        }
        return new SendChannelInfo(7, ownedIdentity, ownedIdentity);
    }

    public static SendChannelInfo createAsymmetricBroadcastChannelInfo(Identity toIdentity, Identity fromIdentity) {
        if (toIdentity == null || fromIdentity == null) {
            return null;
        }
        return new SendChannelInfo(4, toIdentity, fromIdentity);
    }

    public static SendChannelInfo createUserInterfaceChannelInfo(Identity ownedIdentity, DialogType dialogType, UUID dialogUuid) {
        if (ownedIdentity == null || dialogType == null || dialogUuid == null) {
            return null;
        }
        return new SendChannelInfo(5, ownedIdentity, ownedIdentity, null, null, dialogType, dialogUuid, null, null);
    }

    public static SendChannelInfo createServerQueryChannelInfo(Identity ownedIdentity, ServerQuery.Type serverQueryType) {
        if (ownedIdentity == null || serverQueryType == null) {
            return null;
        }
        return new SendChannelInfo(6, ownedIdentity, ownedIdentity, null, null, null, null, serverQueryType, null);
    }

    public int getChannelType() {
        return this.channelType;
    }

    public Identity getToIdentity() {
        return this.toIdentity;
    }

    public UID[] getRemoteDeviceUids() {
        return this.remoteDeviceUids;
    }

    public Identity getFromIdentity() {
        return this.fromIdentity;
    }

    public Boolean getNecessarilyConfirmed() {
        return this.necessarilyConfirmed;
    }

    public DialogType getDialogType() {
        return this.dialogType;
    }

    public UUID getDialogUuid() {
        return this.dialogUuid;
    }

    public ServerQuery.Type getServerQueryType() {
        return this.serverQueryType;
    }

    public Identity[] getToIdentities() {
        return this.toIdentities;
    }
}

