/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.channel.datatypes.ChannelReceivedMessage;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.encoder.Encoded;

public class ProtocolReceivedMessage {
    private final UID messageUid;
    private final Identity ownedIdentity;
    private final Encoded encodedElements;
    private final ReceptionChannelInfo receptionChannelInfo;
    private final long serverTimestamp;

    public ProtocolReceivedMessage(UID messageUid, Identity ownedIdentity, Encoded encodedElements, ReceptionChannelInfo receptionChannelInfo, long serverTimestamp) {
        this.messageUid = messageUid;
        this.ownedIdentity = ownedIdentity;
        this.encodedElements = encodedElements;
        this.receptionChannelInfo = receptionChannelInfo;
        this.serverTimestamp = serverTimestamp;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public Encoded getEncodedElements() {
        return this.encodedElements;
    }

    public ReceptionChannelInfo getReceptionChannelInfo() {
        return this.receptionChannelInfo;
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }

    public static ProtocolReceivedMessage of(ChannelReceivedMessage message) {
        if (message.getMessageType() != 0) {
            return null;
        }
        return new ProtocolReceivedMessage(message.getMessageUid(), message.getOwnedIdentity(), message.getEncodedElements(), message.getReceptionChannelInfo(), message.getMessage().getServerTimestamp());
    }
}

