/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;

public class MessageToSend {
    private final Identity ownedIdentity;
    private final UID uid;
    private final String server;
    private final EncryptedBytes encryptedContent;
    private final EncryptedBytes encryptedExtendedContent;
    private final Header[] headers;
    private final Attachment[] attachments;
    private final boolean isApplicationMessage;
    private final boolean isVoipMessage;

    public MessageToSend(Identity ownedIdentity, UID uid, String server, EncryptedBytes encryptedContent, Header[] headers, boolean hasUserContent) {
        this(ownedIdentity, uid, server, encryptedContent, null, headers, new Attachment[0], hasUserContent, false);
    }

    public MessageToSend(Identity ownedIdentity, UID uid, String server, EncryptedBytes encryptedContent, EncryptedBytes encryptedExtendedContent, Header[] headers, Attachment[] attachments, boolean isApplicationMessage, boolean isVoipMessage) {
        this.ownedIdentity = ownedIdentity;
        this.uid = uid;
        this.server = server;
        this.encryptedContent = encryptedContent;
        this.encryptedExtendedContent = encryptedExtendedContent;
        this.headers = headers;
        this.attachments = attachments;
        this.isApplicationMessage = isApplicationMessage;
        this.isVoipMessage = isVoipMessage;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getUid() {
        return this.uid;
    }

    public String getServer() {
        return this.server;
    }

    public EncryptedBytes getEncryptedContent() {
        return this.encryptedContent;
    }

    public EncryptedBytes getEncryptedExtendedContent() {
        return this.encryptedExtendedContent;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public Attachment[] getAttachments() {
        return this.attachments;
    }

    public boolean isApplicationMessage() {
        return this.isApplicationMessage;
    }

    public boolean isVoipMessage() {
        return this.isVoipMessage;
    }

    public static class Attachment {
        private final String url;
        private final boolean deleteAfterSend;
        private final long attachmentLength;
        private final AuthEncKey key;

        public Attachment(String url, boolean deleteAfterSend, long attachmentLength, AuthEncKey key) {
            this.url = url;
            this.deleteAfterSend = deleteAfterSend;
            this.attachmentLength = attachmentLength;
            this.key = key;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDeleteAfterSend() {
            return this.deleteAfterSend;
        }

        public long getAttachmentLength() {
            return this.attachmentLength;
        }

        public AuthEncKey getKey() {
            return this.key;
        }
    }

    public static class Header {
        private final UID deviceUid;
        private final Identity toIdentity;
        private final EncryptedBytes wrappedMessageKey;

        public Header(UID deviceUid, Identity toIdentity, EncryptedBytes wrappedMessageKey) {
            this.deviceUid = deviceUid;
            this.toIdentity = toIdentity;
            this.wrappedMessageKey = wrappedMessageKey;
        }

        public UID getDeviceUid() {
            return this.deviceUid;
        }

        public Identity getToIdentity() {
            return this.toIdentity;
        }

        public EncryptedBytes getWrappedMessageKey() {
            return this.wrappedMessageKey;
        }
    }
}

