/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;

public class IdentityAndUid {
    public final Identity identity;
    public final UID uid;

    public IdentityAndUid(Identity identity, UID uid) {
        this.identity = identity;
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IdentityAndUid)) {
            return false;
        }
        IdentityAndUid other = (IdentityAndUid)o;
        return this.identity.equals(other.identity) && this.uid.equals(other.uid);
    }

    public int hashCode() {
        return this.identity.hashCode() ^ this.uid.hashCode();
    }

    public String toString() {
        return String.valueOf(this.identity) + " - " + String.valueOf(this.uid);
    }

    public static UID computeUniqueUid(Identity ownedIdentity, UID uid) {
        Hash sha256 = Suite.getHash("sha-256");
        byte[] input = new byte[ownedIdentity.getBytes().length + 32];
        System.arraycopy(ownedIdentity.getBytes(), 0, input, 0, ownedIdentity.getBytes().length);
        System.arraycopy(uid.getBytes(), 0, input, ownedIdentity.getBytes().length, 32);
        return new UID(sha256.digest(input));
    }
}

