/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.containers.IdentityWithSerializedDetails;

public class Group {
    private final byte[] groupOwnerAndUid;
    private final Identity ownedIdentity;
    private final Identity[] groupMembers;
    private final IdentityWithSerializedDetails[] pendingGroupMembers;
    private final Identity[] declinedPendingMembers;
    private final Identity groupOwner;
    private final long groupMembersVersion;

    public Group(byte[] groupOwnerAndUid, Identity ownedIdentity, Identity[] groupMembers, IdentityWithSerializedDetails[] pendingGroupMembers, Identity[] declinedPendingMembers, Identity groupOwner, long groupMembersVersion) {
        this.groupOwnerAndUid = groupOwnerAndUid;
        this.ownedIdentity = ownedIdentity;
        this.groupMembers = groupMembers;
        this.pendingGroupMembers = pendingGroupMembers;
        this.declinedPendingMembers = declinedPendingMembers;
        this.groupOwner = groupOwner;
        this.groupMembersVersion = groupMembersVersion;
    }

    public byte[] getGroupOwnerAndUid() {
        return this.groupOwnerAndUid;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public Identity[] getGroupMembers() {
        return this.groupMembers;
    }

    public IdentityWithSerializedDetails[] getPendingGroupMembers() {
        return this.pendingGroupMembers;
    }

    public Identity[] getDeclinedPendingMembers() {
        return this.declinedPendingMembers;
    }

    public Identity getGroupOwner() {
        return this.groupOwner;
    }

    public long getGroupMembersVersion() {
        return this.groupMembersVersion;
    }

    public boolean isMember(Identity contactIdentity) {
        for (Identity memberIdentity : this.groupMembers) {
            if (!memberIdentity.equals(contactIdentity)) continue;
            return true;
        }
        return false;
    }

    public boolean isPendingMember(Identity contactIdentity) {
        for (IdentityWithSerializedDetails pendingMember : this.pendingGroupMembers) {
            if (!pendingMember.identity.equals(contactIdentity)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeclinedPendingMember(Identity contactIdentity) {
        for (Identity pendingMember : this.declinedPendingMembers) {
            if (!pendingMember.equals(contactIdentity)) continue;
            return true;
        }
        return false;
    }
}

