/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.SendChannelInfo;

public class ChannelApplicationMessageToSend
implements ChannelMessageToSend {
    private final SendChannelInfo sendChannelInfo;
    private final Attachment[] attachments;
    private final byte[] messagePayload;
    private final byte[] extendedMessagePayload;
    private final boolean hasUserContent;
    private final boolean isVoipMessage;

    public ChannelApplicationMessageToSend(Identity[] toIdentities, Identity fromIdentity, byte[] messagePayload, byte[] extendedMessagePayload, Attachment[] attachments, boolean hasUserContent, boolean isVoipMessage) throws Exception {
        SendChannelInfo[] sendChannelInfos = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(toIdentities, fromIdentity);
        if (sendChannelInfos.length != 1) {
            Logger.e("Error: trying to create a ChannelApplicationMessageToSend for identities on different servers");
            throw new Exception();
        }
        this.sendChannelInfo = sendChannelInfos[0];
        this.messagePayload = messagePayload;
        this.extendedMessagePayload = extendedMessagePayload;
        this.attachments = attachments;
        this.hasUserContent = hasUserContent;
        this.isVoipMessage = isVoipMessage;
    }

    public ChannelApplicationMessageToSend(Identity[] toIdentities, UID[] toDeviceUids, Identity fromIdentity, byte[] messagePayload, byte[] extendedMessagePayload, Attachment[] attachments, boolean hasUserContent, boolean isVoipMessage) throws Exception {
        SendChannelInfo[] sendChannelInfos = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(toIdentities, toDeviceUids, fromIdentity);
        if (sendChannelInfos.length != 1) {
            Logger.e("Error: trying to create a ChannelApplicationMessageToSend for identities on different servers");
            throw new Exception();
        }
        this.sendChannelInfo = sendChannelInfos[0];
        this.messagePayload = messagePayload;
        this.extendedMessagePayload = extendedMessagePayload;
        this.attachments = attachments;
        this.hasUserContent = hasUserContent;
        this.isVoipMessage = isVoipMessage;
    }

    @Override
    public int getMessageType() {
        return 1;
    }

    @Override
    public SendChannelInfo getSendChannelInfo() {
        return this.sendChannelInfo;
    }

    public byte[] getMessagePayload() {
        return this.messagePayload;
    }

    public byte[] getExtendedMessagePayload() {
        return this.extendedMessagePayload;
    }

    public Attachment[] getAttachments() {
        return this.attachments;
    }

    public boolean hasUserContent() {
        return this.hasUserContent;
    }

    public boolean isVoipMessage() {
        return this.isVoipMessage;
    }

    public static class Attachment {
        private final String url;
        private final boolean deleteAfterSend;
        private final long attachmentLength;
        private final byte[] metadata;

        public Attachment(String url, boolean deleteAfterSend, long attachmentLength, byte[] metadata) {
            this.url = url;
            this.deleteAfterSend = deleteAfterSend;
            this.attachmentLength = attachmentLength;
            this.metadata = metadata;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDeleteAfterSend() {
            return this.deleteAfterSend;
        }

        public long getAttachmentLength() {
            return this.attachmentLength;
        }

        public byte[] getMetadata() {
            return this.metadata;
        }
    }
}

