/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNG;
import java.util.Arrays;

public class UID
implements Comparable<UID> {
    public static final int UID_LENGTH = 32;
    private final byte[] uid;

    public UID(byte[] uid) throws IllegalArgumentException {
        if (uid.length != 32) {
            throw new IllegalArgumentException();
        }
        this.uid = uid;
    }

    public UID(String uidHexString) {
        this(Logger.fromHexString(uidHexString));
    }

    public UID(PRNG prng) {
        this(prng.bytes(32));
    }

    public static UID fromLong(long l) {
        byte[] bytes = new byte[32];
        bytes[0] = (byte)(l & 0xFFL);
        bytes[1] = (byte)(l >> 8 & 0xFFL);
        bytes[2] = (byte)(l >> 16 & 0xFFL);
        bytes[3] = (byte)(l >> 24 & 0xFFL);
        bytes[4] = (byte)(l >> 32 & 0xFFL);
        bytes[5] = (byte)(l >> 40 & 0xFFL);
        bytes[6] = (byte)(l >> 48 & 0xFFL);
        bytes[7] = (byte)(l >> 56 & 0xFFL);
        return new UID(bytes);
    }

    public byte[] getBytes() {
        return this.uid;
    }

    public String toString() {
        return Logger.toHexString(this.uid);
    }

    public boolean equals(Object other) {
        if (!(other instanceof UID)) {
            return false;
        }
        return Arrays.equals(this.uid, ((UID)other).uid);
    }

    public int hashCode() {
        return Arrays.hashCode(this.uid);
    }

    @Override
    public int compareTo(UID otherUid) {
        for (int i = 0; i < 32; ++i) {
            if (this.uid[i] == otherUid.uid[i]) continue;
            return (this.uid[i] & 0xFF) - (otherUid.uid[i] & 0xFF);
        }
        return 0;
    }
}

