/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.DeferrablePreparedStatement;
import io.olvid.engine.datatypes.DeferrableStatement;
import io.olvid.engine.datatypes.SessionCommitListener;
import io.olvid.engine.engine.types.EngineDbQueryStatisticsEntry;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class Session
implements AutoCloseable {
    public static final Map<String, EngineDbQueryStatisticsEntry> queryStatistics = new ConcurrentHashMap<String, EngineDbQueryStatisticsEntry>();
    static final ReentrantLock globalWriteLock = new ReentrantLock();
    private static final HashMap<String, List<Session>> sessionPool = new HashMap();
    private static final ReentrantLock sessionPoolLock = new ReentrantLock();
    private final Connection connection;
    private final Set<SessionCommitListener> sessionCommitListeners;
    private final String dbPath;
    private final boolean sessionIsForUpgradeTable;

    private Session(String dbPath, String dbKey, boolean sessionIsForUpgradeTables) throws SQLException {
        if (dbPath == null) {
            throw new SQLException("dbPath is null, unable to create a Session.");
        }
        this.dbPath = dbPath;
        this.sessionCommitListeners = new LinkedHashSet<SessionCommitListener>();
        this.sessionIsForUpgradeTable = sessionIsForUpgradeTables;
        Properties properties = new Properties();
        properties.setProperty("secure_delete", "on");
        properties.setProperty("temp_store", "2");
        properties.setProperty("journal_mode", "WAL");
        properties.setProperty("busy_timeout", "10000");
        if (dbKey != null) {
            properties.setProperty("password", dbKey);
        }
        if (sessionIsForUpgradeTables) {
            properties.setProperty("legacy_alter_table", "true");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbPath, properties);
        } else {
            properties.setProperty("foreign_keys", "true");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbPath, properties);
            this.connection.setAutoCommit(true);
        }
    }

    public static Session getSession(String dbPath, String dbKey) throws SQLException {
        Session session;
        sessionPoolLock.lock();
        List<Session> sessionList = sessionPool.get(dbPath);
        if (sessionList == null || sessionList.isEmpty()) {
            sessionPoolLock.unlock();
            session = new Session(dbPath, dbKey, false);
        } else {
            session = sessionList.remove(0);
            sessionPoolLock.unlock();
        }
        return session;
    }

    public static Session getUpgradeTablesSession(String dbPath, String dbKey) throws SQLException {
        return new Session(dbPath, dbKey, true);
    }

    public void addSessionCommitListener(SessionCommitListener listener) {
        this.sessionCommitListeners.add(listener);
    }

    public boolean isInTransaction() throws SQLException {
        return !this.connection.getAutoCommit();
    }

    public void startTransaction() throws SQLException {
        if (this.isInTransaction()) {
            Logger.e("Starting transaction from within a transaction!");
            Logger.x(new Exception("Trace"));
            return;
        }
        globalWriteLock.lock();
        this.connection.setAutoCommit(false);
    }

    public static boolean databaseIsReadable(String dbPath, String dbKey) {
        boolean bl;
        Session session = new Session(dbPath, dbKey, true);
        try {
            try (Statement statement = session.createStatement();){
                statement.execute("SELECT count(*) FROM sqlite_master;");
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    session.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                return false;
            }
        }
        session.close();
        return bl;
    }

    public void commit() throws SQLException {
        if (!this.connection.getAutoCommit()) {
            this.connection.commit();
            this.connection.setAutoCommit(true);
            globalWriteLock.unlock();
        }
        for (SessionCommitListener sessionCommitListener : this.sessionCommitListeners.toArray(new SessionCommitListener[0])) {
            sessionCommitListener.wasCommitted();
        }
        this.sessionCommitListeners.clear();
    }

    public void rollback() throws SQLException {
        if (!this.connection.getAutoCommit()) {
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
                this.sessionCommitListeners.clear();
            }
            finally {
                globalWriteLock.unlock();
            }
        } else {
            Logger.d("Calling rollback on an autoCommit Session.");
        }
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(null);
    }

    public Statement createStatement(String tag) throws SQLException {
        return new DeferrableStatement(tag, this.connection.createStatement(), this);
    }

    public PreparedStatement prepareStatement(String s) throws SQLException {
        return this.prepareStatement(null, s);
    }

    public PreparedStatement prepareStatement(String tag, String s) throws SQLException {
        return new DeferrablePreparedStatement(tag, this.connection.prepareStatement(s), this);
    }

    public PreparedStatement prepareStatement(String s, boolean returnGeneratedKeys) throws SQLException {
        return this.prepareStatement(null, s, returnGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String tag, String s, boolean returnGeneratedKeys) throws SQLException {
        return new DeferrablePreparedStatement(tag, this.connection.prepareStatement(s, returnGeneratedKeys ? 1 : 2), this);
    }

    @Override
    public void close() throws SQLException {
        if (!this.sessionCommitListeners.isEmpty()) {
            Logger.e("This Session was not properly closed: some modifications were committed and the corresponding hooks have not been called.");
            for (SessionCommitListener sessionCommitListener : this.sessionCommitListeners) {
                Logger.e("  - Un-committed entity: " + String.valueOf(sessionCommitListener.getClass()));
            }
            this.sessionCommitListeners.clear();
            Logger.x(new Exception("Trace"));
        }
        if (!this.getAutoCommit()) {
            this.rollback();
        }
        if (this.sessionIsForUpgradeTable) {
            this.connection.close();
        } else {
            sessionPoolLock.lock();
            List<Session> sessionList = sessionPool.get(this.dbPath);
            if (sessionList == null || sessionList.isEmpty()) {
                sessionList = new ArrayList<Session>();
                sessionPool.put(this.dbPath, sessionList);
            }
            sessionList.add(this);
            sessionPoolLock.unlock();
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    static void registerQueryTime(String tag, long timeMicro) {
        if (tag == null) {
            return;
        }
        queryStatistics.compute(tag, (key, val) -> {
            if (val == null) {
                return EngineDbQueryStatisticsEntry.create(timeMicro);
            }
            return val.increment(timeMicro);
        });
    }

    static {
        try {
            DriverManager.registerDriver((Driver)Class.forName("org.sqlite.JDBC").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }
}

