/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.datatypes.UID;
import java.util.Arrays;

public class PushNotificationTypeAndParameters {
    public static final byte PUSH_NOTIFICATION_TYPE_ANDROID = 1;
    public static final byte PUSH_NOTIFICATION_TYPE_WEBSOCKET_ANDROID = 16;
    public static final byte PUSH_NOTIFICATION_TYPE_WEBSOCKET_WINDOWS = 17;
    public static final byte PUSH_NOTIFICATION_TYPE_WEBSOCKET_LINUX = 18;
    public static final byte PUSH_NOTIFICATION_TYPE_WEBSOCKET_DAEMON = 19;
    public final byte pushNotificationType;
    public final byte[] token;
    public UID identityMaskingUid;
    public boolean reactivateCurrentDevice;
    public UID deviceUidToReplace;

    public PushNotificationTypeAndParameters(byte pushNotificationType, byte[] token, UID identityMaskingUid, boolean reactivateCurrentDevice, UID deviceUidToReplace) {
        this.pushNotificationType = pushNotificationType;
        this.token = token;
        this.identityMaskingUid = identityMaskingUid;
        this.reactivateCurrentDevice = reactivateCurrentDevice;
        this.deviceUidToReplace = deviceUidToReplace;
    }

    public static PushNotificationTypeAndParameters createWebsocketOnlyAndroid(boolean reactivateCurrentDevice, UID deviceUidToReplace) {
        return new PushNotificationTypeAndParameters(16, null, null, reactivateCurrentDevice, deviceUidToReplace);
    }

    public static PushNotificationTypeAndParameters createWindows(boolean reactivateCurrentDevice, UID deviceUidToReplace) {
        return new PushNotificationTypeAndParameters(17, null, null, reactivateCurrentDevice, deviceUidToReplace);
    }

    public static PushNotificationTypeAndParameters createLinux(boolean reactivateCurrentDevice, UID deviceUidToReplace) {
        return new PushNotificationTypeAndParameters(18, null, null, reactivateCurrentDevice, deviceUidToReplace);
    }

    public static PushNotificationTypeAndParameters createDaemon(boolean reactivateCurrentDevice, UID deviceUidToReplace) {
        return new PushNotificationTypeAndParameters(19, null, null, reactivateCurrentDevice, deviceUidToReplace);
    }

    public static PushNotificationTypeAndParameters createFirebaseAndroid(byte[] token, UID identityMaskingUid, boolean reactivateCurrentDevice, UID deviceUidToReplace) {
        return new PushNotificationTypeAndParameters(1, token, identityMaskingUid, reactivateCurrentDevice, deviceUidToReplace);
    }

    public boolean sameTypeAndToken(PushNotificationTypeAndParameters other) {
        if (this.pushNotificationType != other.pushNotificationType) {
            return false;
        }
        switch (this.pushNotificationType) {
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
            case 1: {
                return Arrays.equals(this.token, other.token);
            }
        }
        return false;
    }
}

