/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.PriorityOperation;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PriorityOperationQueue {
    private final PriorityBlockingQueue<PriorityOperation> operations = new PriorityBlockingQueue();
    private final List<PriorityOperation> executingOperations = new LinkedList<PriorityOperation>();
    private final Lock lockOnExecutingOperations = new ReentrantLock();
    private boolean executing = false;
    private int numberOfThreads = 0;

    public void queue(PriorityOperation op) {
        if (!op.getDependencies().isEmpty()) {
            Logger.e("Cannot queue an operation with dependencies into a PriorityOperationQueue.");
            return;
        }
        op.setPending();
        this.operations.add(op);
    }

    public void execute(int numberOfThreads) {
        this.execute(numberOfThreads, null);
    }

    public void execute(int numberOfThreads, String tag) {
        if (this.executing) {
            Logger.e("You can only call execute once on a PriorityOperationQueue.");
            return;
        }
        this.executing = true;
        this.numberOfThreads = numberOfThreads;
        for (int i = 0; i < numberOfThreads; ++i) {
            new PriorityOperationQueueThread(i, tag).start();
        }
    }

    public PriorityOperation getExecutingOperationThatShouldBeCancelledWhenQueueingWithHigherPriority() {
        PriorityOperation op = null;
        long maxPriority = 0L;
        this.lockOnExecutingOperations.lock();
        if (this.executingOperations.size() < this.numberOfThreads) {
            this.lockOnExecutingOperations.unlock();
            return null;
        }
        for (PriorityOperation operation : this.executingOperations) {
            long priority = operation.getPriority();
            if (op != null && priority <= maxPriority) continue;
            op = operation;
            maxPriority = priority;
        }
        this.lockOnExecutingOperations.unlock();
        return op;
    }

    class PriorityOperationQueueThread
    extends Thread {
        public final int threadNumber;

        public PriorityOperationQueueThread(int i, String tag) {
            this.threadNumber = i;
            if (tag != null) {
                this.setName(tag + "-" + this.threadNumber);
            }
        }

        @Override
        public void run() {
            while (true) {
                long timeToWait;
                PriorityOperation op;
                try {
                    op = PriorityOperationQueue.this.operations.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                op.updateReadiness();
                op.processCancel();
                if (op.getTimestampOfLastExecution() != 0L && (timeToWait = op.getTimestampOfLastExecution() - System.currentTimeMillis() + 20L) > 0L) {
                    try {
                        PriorityOperationQueueThread.sleep(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                op.setTimestampOfLastExecution(System.currentTimeMillis());
                if (!op.isReady()) continue;
                if (op.areConditionsFulfilled()) {
                    PriorityOperationQueue.this.lockOnExecutingOperations.lock();
                    PriorityOperationQueue.this.executingOperations.add(op);
                    PriorityOperationQueue.this.lockOnExecutingOperations.unlock();
                    try {
                        op.execute();
                    }
                    catch (Exception e) {
                        Logger.e("Exception in operation that could have killed a queue!");
                        Logger.x(e);
                    }
                    PriorityOperationQueue.this.lockOnExecutingOperations.lock();
                    PriorityOperationQueue.this.executingOperations.remove(op);
                    PriorityOperationQueue.this.lockOnExecutingOperations.unlock();
                    continue;
                }
                PriorityOperationQueue.this.operations.add(op);
            }
        }
    }
}

