/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.PriorityOperation;
import io.olvid.engine.datatypes.UID;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NoDuplicatePriorityOperationQueue {
    private final PriorityBlockingQueue<PriorityOperation> operations;
    private final Lock lockOnQueuedOperationUids;
    private final Set<UID> queuedOperationUids = new HashSet<UID>();
    private boolean executing = false;

    public NoDuplicatePriorityOperationQueue() {
        this.lockOnQueuedOperationUids = new ReentrantLock();
        this.operations = new PriorityBlockingQueue();
    }

    public void queue(PriorityOperation op) {
        if (!op.getDependencies().isEmpty()) {
            Logger.e("Cannot queue an operation with dependencies into a NoDuplicatePriorityOperationQueue.");
            return;
        }
        UID uid = op.getUid();
        if (uid != null) {
            this.lockOnQueuedOperationUids.lock();
            if (this.queuedOperationUids.contains(uid)) {
                this.lockOnQueuedOperationUids.unlock();
                return;
            }
            this.queuedOperationUids.add(uid);
            this.lockOnQueuedOperationUids.unlock();
        }
        op.setPending();
        this.operations.add(op);
    }

    public void execute(int numberOfThreads) {
        this.execute(numberOfThreads, null);
    }

    public void execute(int numberOfThreads, String tag) {
        if (this.executing) {
            Logger.e("You can only call execute once on a NoDuplicatePriorityOperationQueue.");
            return;
        }
        this.executing = true;
        for (int i = 0; i < numberOfThreads; ++i) {
            new NoDuplicatePriorityOperationQueueThread(i, tag).start();
        }
    }

    class NoDuplicatePriorityOperationQueueThread
    extends Thread {
        final int threadNumber;

        NoDuplicatePriorityOperationQueueThread(int i, String tag) {
            this.threadNumber = i;
            if (tag != null) {
                this.setName(tag + "-" + this.threadNumber);
            }
        }

        @Override
        public void run() {
            while (true) {
                long timeToWait;
                PriorityOperation op;
                try {
                    op = NoDuplicatePriorityOperationQueue.this.operations.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                op.updateReadiness();
                op.processCancel();
                if (op.getTimestampOfLastExecution() != 0L && (timeToWait = op.getTimestampOfLastExecution() - System.currentTimeMillis() + 20L) > 0L) {
                    try {
                        NoDuplicatePriorityOperationQueueThread.sleep(timeToWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                op.setTimestampOfLastExecution(System.currentTimeMillis());
                if (!op.isReady()) continue;
                if (op.areConditionsFulfilled()) {
                    if (op.getUid() != null) {
                        NoDuplicatePriorityOperationQueue.this.lockOnQueuedOperationUids.lock();
                        NoDuplicatePriorityOperationQueue.this.queuedOperationUids.remove(op.getUid());
                        NoDuplicatePriorityOperationQueue.this.lockOnQueuedOperationUids.unlock();
                    }
                    try {
                        op.execute();
                    }
                    catch (Exception e) {
                        Logger.e("Exception in operation that could have killed a queue!");
                        Logger.x(e);
                    }
                    continue;
                }
                NoDuplicatePriorityOperationQueue.this.operations.add(op);
            }
        }
    }
}

