/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import java.util.ArrayList;
import java.util.List;

public class EtaEstimator {
    public static final int MIN_SAMPLE_COUNT = 10;
    public static final long MIN_SAMPLE_DURATION = 10000L;
    private final long totalBytes;
    private final List<Sample> samples;
    private int offset = 0;

    public EtaEstimator(long initialBytes, long totalBytes) {
        this.totalBytes = totalBytes;
        this.samples = new ArrayList<Sample>();
        this.samples.add(new Sample(System.currentTimeMillis(), initialBytes));
    }

    public void update(long currentBytes) {
        long timestamp = System.currentTimeMillis();
        this.samples.add(new Sample(timestamp, currentBytes));
        while (this.samples.size() - this.offset > 10 && timestamp - this.samples.get((int)this.offset).timestamp > 10000L) {
            ++this.offset;
        }
    }

    public SpeedAndEta getSpeedAndEta() {
        Sample start = this.samples.get(this.offset);
        Sample end = this.samples.get(this.samples.size() - 1);
        long elapsed = end.timestamp - start.timestamp;
        long xferred = end.byteCount - start.byteCount;
        if (elapsed == 0L || xferred == 0L) {
            return new SpeedAndEta(0.0f, 0);
        }
        float speed = 1000.0f * (float)xferred / (float)elapsed;
        int eta = Math.round((float)(this.totalBytes - end.byteCount) / speed);
        return new SpeedAndEta(speed, eta);
    }

    private static class Sample {
        long timestamp;
        long byteCount;

        public Sample(long timestamp, long byteCount) {
            this.timestamp = timestamp;
            this.byteCount = byteCount;
        }
    }

    public static class SpeedAndEta {
        public final float speedBps;
        public final int etaSeconds;

        public SpeedAndEta(float speedBps, int etaSeconds) {
            this.speedBps = speedBps;
            this.etaSeconds = etaSeconds;
        }
    }
}

