/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes;

import io.olvid.engine.datatypes.Session;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

class DeferrableStatement
implements Statement {
    private final String tag;
    private final Statement statement;
    private final Session session;

    DeferrableStatement(String tag, Statement statement, Session session) {
        this.tag = tag;
        this.statement = statement;
        this.session = session;
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String s) throws SQLException {
        boolean res;
        long startTime;
        if (this.session.getAutoCommit()) {
            try {
                Session.globalWriteLock.lock();
                startTime = System.nanoTime();
                res = this.statement.execute(s);
            }
            finally {
                Session.globalWriteLock.unlock();
            }
        } else {
            startTime = System.nanoTime();
            res = this.statement.execute(s);
        }
        Session.registerQueryTime(this.tag, (System.nanoTime() - startTime) / 1000L);
        return res;
    }

    @Override
    public ResultSet executeQuery(String s) throws SQLException {
        long startTime = System.nanoTime();
        ResultSet res = this.statement.executeQuery(s);
        Session.registerQueryTime(this.tag, (System.nanoTime() - startTime) / 1000L);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String s) throws SQLException {
        int res;
        long startTime;
        if (this.session.getAutoCommit()) {
            try {
                Session.globalWriteLock.lock();
                startTime = System.nanoTime();
                res = this.statement.executeUpdate(s);
            }
            finally {
                Session.globalWriteLock.unlock();
            }
        } else {
            startTime = System.nanoTime();
            res = this.statement.executeUpdate(s);
        }
        Session.registerQueryTime(this.tag, (System.nanoTime() - startTime) / 1000L);
        return res;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
        this.statement.setMaxFieldSize(i);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        this.statement.setMaxRows(i);
    }

    @Override
    public void setEscapeProcessing(boolean b) throws SQLException {
        this.statement.setEscapeProcessing(b);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
        this.statement.setQueryTimeout(i);
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String s) throws SQLException {
        this.statement.setCursorName(s);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        this.statement.setFetchDirection(i);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        this.statement.setFetchSize(i);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public void addBatch(String s) throws SQLException {
        this.statement.addBatch(s);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        return this.statement.getMoreResults(i);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String s, int i) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public int executeUpdate(String s, int[] ints) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public int executeUpdate(String s, String[] strings) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public boolean execute(String s, int[] ints) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public boolean execute(String s, String[] strings) throws SQLException {
        throw new SQLException("Not implemented");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public void setPoolable(boolean b) throws SQLException {
        this.statement.setPoolable(b);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        return this.statement.unwrap(aClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return this.statement.isWrapperFor(aClass);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.statement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.statement.isCloseOnCompletion();
    }
}

