/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.Curve25519;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.SignatureECSdsa;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaCurve25519PrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaCurve25519PublicKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePublicKey;
import java.security.InvalidKeyException;

class SignatureECSdsaCurve25519
extends SignatureECSdsa {
    SignatureECSdsaCurve25519() {
        super(Curve25519.getInstance());
    }

    @Override
    public byte[] sign(SignaturePrivateKey privateKey, byte[] message, PRNGService prng) throws InvalidKeyException {
        if (!(privateKey instanceof SignatureECSdsaCurve25519PrivateKey)) {
            throw new InvalidKeyException();
        }
        return this.internalSign((SignatureECSdsaPrivateKey)privateKey, message, prng);
    }

    @Override
    public byte[] sign(SignaturePrivateKey privateKey, SignaturePublicKey publicKey, byte[] message, PRNGService prng) throws InvalidKeyException {
        if (!(privateKey instanceof SignatureECSdsaCurve25519PrivateKey)) {
            throw new InvalidKeyException();
        }
        return this.internalSign((SignatureECSdsaPrivateKey)privateKey, (SignatureECSdsaPublicKey)publicKey, message, prng);
    }

    @Override
    public boolean verify(SignaturePublicKey publicKey, byte[] message, byte[] signature) throws InvalidKeyException {
        if (!(publicKey instanceof SignatureECSdsaCurve25519PublicKey)) {
            throw new InvalidKeyException();
        }
        return this.internalVerify((SignatureECSdsaPublicKey)publicKey, message, signature);
    }
}

