/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.EdwardCurve;
import io.olvid.engine.crypto.HashSHA256;
import io.olvid.engine.crypto.HashSHA512;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.EdwardCurvePoint;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaPublicKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.encoder.EncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;

abstract class SignatureECSdsa
extends Signature {
    private final EdwardCurve curve;

    SignatureECSdsa(EdwardCurve curve) {
        this.curve = curve;
    }

    public byte[] internalSign(SignatureECSdsaPrivateKey privateKey, byte[] message, PRNGService prng) {
        try {
            EdwardCurvePoint A = this.curve.scalarMultiplicationWithX(privateKey.getA(), this.curve.G);
            HashMap<DictionaryKey, Encoded> publicKeyDictionary = new HashMap<DictionaryKey, Encoded>();
            publicKeyDictionary.put(new DictionaryKey("x"), Encoded.of(A.getX(), this.curve.byteLength));
            publicKeyDictionary.put(new DictionaryKey("y"), Encoded.of(A.getY(), this.curve.byteLength));
            SignatureECSdsaPublicKey publicKey = new SignatureECSdsaPublicKey(privateKey.getAlgorithmImplementation(), publicKeyDictionary){};
            return this.internalSign(privateKey, publicKey, message, prng);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] internalSign(SignatureECSdsaPrivateKey privateKey, SignatureECSdsaPublicKey publicKey, byte[] message, PRNGService prng) {
        try {
            int l = this.curve.byteLength;
            byte[] hashInput = new byte[message.length + 2 * l];
            EdwardCurve.ScalarAndPoint aAndaG = this.curve.generateRandomScalarAndPoint(prng);
            System.arraycopy(Encoded.bytesFromBigUInt(aAndaG.getPoint().getY(), l), 0, hashInput, 0, l);
            System.arraycopy(Encoded.bytesFromBigUInt(publicKey.getAy(), l), 0, hashInput, l, l);
            System.arraycopy(message, 0, hashInput, 2 * l, message.length);
            byte[] hash = new HashSHA256().digest(hashInput);
            BigInteger e = Encoded.bigUIntFromBytes(hash);
            BigInteger y = aAndaG.getScalar().subtract(privateKey.getA().multiply(e)).mod(this.curve.q);
            byte[] signature = new byte[hash.length + l];
            System.arraycopy(hash, 0, signature, 0, hash.length);
            System.arraycopy(Encoded.bytesFromBigUInt(y, l), 0, signature, hash.length, l);
            return signature;
        }
        catch (EncodingException encodingException) {
            return null;
        }
    }

    public boolean internalVerify(SignatureECSdsaPublicKey publicKey, byte[] message, byte[] signature) {
        try {
            boolean isSha512;
            int l = this.curve.byteLength;
            if (signature.length == 32 + l) {
                isSha512 = false;
            } else if (signature.length == 64 + l) {
                isSha512 = true;
            } else {
                return false;
            }
            EdwardCurvePoint A = EdwardCurvePoint.noCheckFactory(publicKey.getAx(), publicKey.getAy(), this.curve);
            if (A.isLowOrderPoint()) {
                return false;
            }
            byte[] hash = Arrays.copyOfRange(signature, 0, signature.length - l);
            BigInteger e = Encoded.bigUIntFromBytes(hash);
            BigInteger y = Encoded.bigUIntFromBytes(Arrays.copyOfRange(signature, signature.length - l, signature.length));
            if (y.compareTo(this.curve.q) >= 0) {
                return false;
            }
            EdwardCurvePoint[] points = this.curve.mulAdd(y, this.curve.G, e, A);
            byte[] hashInput = new byte[message.length + 2 * l];
            System.arraycopy(Encoded.bytesFromBigUInt(publicKey.getAy(), l), 0, hashInput, l, l);
            System.arraycopy(message, 0, hashInput, 2 * l, message.length);
            boolean found = false;
            for (EdwardCurvePoint point : points) {
                byte[] recomputedHash;
                System.arraycopy(Encoded.bytesFromBigUInt(point.getY(), l), 0, hashInput, 0, l);
                byte[] byArray = recomputedHash = isSha512 ? new HashSHA512().digest(hashInput) : new HashSHA256().digest(hashInput);
                if (!MessageDigest.isEqual(hash, recomputedHash)) continue;
                found = true;
            }
            return found;
        }
        catch (EncodingException encodingException) {
            return false;
        }
    }
}

