/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.PRNGHmacSHA256;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Seed;
import java.math.BigInteger;
import java.security.SecureRandom;

class PRNGServiceHmacSHA256
implements PRNGService {
    public static final int RESEED_FREQUENCY = 100;
    private final SecureRandom rand = new SecureRandom();
    PRNGHmacSHA256 prng;
    int reseedCounter;
    private static final PRNGServiceHmacSHA256 instance = new PRNGServiceHmacSHA256();

    private PRNGServiceHmacSHA256() {
        byte[] seedBytes = new byte[32];
        this.rand.nextBytes(seedBytes);
        this.prng = new PRNGHmacSHA256(new Seed(seedBytes));
        this.reseedCounter = 1;
    }

    public static PRNGServiceHmacSHA256 getInstance() {
        return instance;
    }

    @Override
    public synchronized void reseed(Seed seed) {
        this.prng = new PRNGHmacSHA256(seed);
    }

    @Override
    public synchronized byte[] bytes(int n) {
        byte[] output = this.prng.bytes(n);
        if (this.reseedCounter == 100) {
            byte[] seedBytes = new byte[32];
            this.rand.nextBytes(seedBytes);
            this.prng.reseed(new Seed(seedBytes));
            this.reseedCounter = 1;
        } else {
            ++this.reseedCounter;
        }
        return output;
    }

    @Override
    public synchronized BigInteger bigInt(BigInteger n) {
        return this.prng.bigInt(n);
    }
}

