/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.EdwardCurve;
import io.olvid.engine.crypto.KDFDelegateForAuthEncAES256ThenSHA256;
import io.olvid.engine.crypto.KDFSha256;
import io.olvid.engine.crypto.KEM;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.containers.CiphertextAndKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.encoder.EncodingException;
import java.math.BigInteger;

abstract class KemEcies256Kem512
implements KEM {
    private final EdwardCurve curve;
    public static final int CIPHERTEXT_LENGTH = 32;

    protected KemEcies256Kem512(EdwardCurve curve) {
        this.curve = curve;
    }

    CiphertextAndKey internalEncrypt(EncryptionPublicKey publicKey, PRNGService prng) {
        BigInteger r;
        BigInteger Ay = ((EncryptionEciesPublicKey)publicKey).getAy();
        if (this.curve.isLowOrderPoint(Ay)) {
            return null;
        }
        int l = this.curve.byteLength;
        while ((r = prng.bigInt(this.curve.q)).equals(BigInteger.ZERO)) {
        }
        BigInteger Gy = this.curve.G.getY();
        BigInteger By = this.curve.scalarMultiplication(r, Gy);
        BigInteger Dy = this.curve.scalarMultiplication(r, Ay);
        try {
            byte[] ciphertext = Encoded.bytesFromBigUInt(By, l);
            byte[] seedBytes = new byte[2 * l];
            System.arraycopy(ciphertext, 0, seedBytes, 0, l);
            System.arraycopy(Encoded.bytesFromBigUInt(Dy, l), 0, seedBytes, l, l);
            AuthEncKey key = (AuthEncKey)new KDFSha256().gen(new Seed(seedBytes), new KDFDelegateForAuthEncAES256ThenSHA256())[0];
            return new CiphertextAndKey(key, new EncryptedBytes(ciphertext));
        }
        catch (EncodingException e) {
            return null;
        }
    }

    AuthEncKey internalDecrypt(EncryptionPrivateKey privateKey, byte[] c) {
        BigInteger a = ((EncryptionEciesPrivateKey)privateKey).getA();
        int l = this.curve.byteLength;
        if (c.length != l) {
            return null;
        }
        BigInteger By = Encoded.bigUIntFromBytes(c);
        if ((By = this.curve.scalarMultiplication(this.curve.nu, By)).equals(BigInteger.ONE)) {
            return null;
        }
        a = a.multiply(this.curve.nuInv).mod(this.curve.q);
        BigInteger Dy = this.curve.scalarMultiplication(a, By);
        try {
            byte[] seedBytes = new byte[2 * l];
            System.arraycopy(c, 0, seedBytes, 0, l);
            System.arraycopy(Encoded.bytesFromBigUInt(Dy, l), 0, seedBytes, l, l);
            return (AuthEncKey)new KDFSha256().gen(new Seed(seedBytes), new KDFDelegateForAuthEncAES256ThenSHA256())[0];
        }
        catch (EncodingException e) {
            return null;
        }
    }

    @Override
    public int ciphertextLength() {
        return 32;
    }
}

