/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.Commitment;
import io.olvid.engine.crypto.HashSHA256;
import io.olvid.engine.crypto.PRNGService;
import java.util.Arrays;

class CommitmentWithSHA256
implements Commitment {
    static final int COMMITMENT_RANDOM_LENGTH = 32;

    CommitmentWithSHA256() {
    }

    @Override
    public Commitment.CommitmentOutput commit(byte[] tag, byte[] value, PRNGService prng) {
        HashSHA256 h = new HashSHA256();
        byte[] e = prng.bytes(32);
        byte[] decommitment = new byte[value.length + 32];
        System.arraycopy(value, 0, decommitment, 0, value.length);
        System.arraycopy(e, 0, decommitment, value.length, 32);
        byte[] input = new byte[tag.length + value.length + 32];
        System.arraycopy(tag, 0, input, 0, tag.length);
        System.arraycopy(decommitment, 0, input, tag.length, decommitment.length);
        byte[] commitment = h.digest(input);
        return new Commitment.CommitmentOutput(commitment, decommitment);
    }

    @Override
    public byte[] open(byte[] tag, byte[] commitment, byte[] decommitment) {
        HashSHA256 h = new HashSHA256();
        byte[] input = new byte[tag.length + decommitment.length];
        System.arraycopy(tag, 0, input, 0, tag.length);
        System.arraycopy(decommitment, 0, input, tag.length, decommitment.length);
        byte[] commitment2 = h.digest(input);
        if (Arrays.equals(commitment, commitment2)) {
            return Arrays.copyOfRange(decommitment, 0, decommitment.length - 32);
        }
        return null;
    }
}

