/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.crypto;

import io.olvid.engine.crypto.KDF;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import java.security.InvalidKeyException;

public interface AuthEnc {
    public static final String CTR_AES256_THEN_HMAC_SHA256 = "ctr-aes-256_then_hmac_sha-256";

    public int keyByteLength();

    public int ciphertextLengthFromPlaintextLength(int var1);

    public int plaintextLengthFromCiphertextLength(int var1);

    public EncryptedBytes encrypt(AuthEncKey var1, byte[] var2, PRNG var3) throws InvalidKeyException;

    public byte[] decrypt(AuthEncKey var1, EncryptedBytes var2) throws DecryptionException, InvalidKeyException;

    public KDF.Delegate getKDFDelegate();

    public AuthEncKey generateKey(PRNG var1);

    public AuthEncKey generateMessageKey(PRNG var1, byte[] var2);

    public boolean verifyMessageKey(AuthEncKey var1, byte[] var2);
}

