/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.datatypes;

import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.channel.datatypes.LocalChannel;
import io.olvid.engine.channel.datatypes.NetworkChannel;
import io.olvid.engine.channel.datatypes.ServerQueryChannel;
import io.olvid.engine.channel.datatypes.UserInterfaceChannel;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;

public abstract class Channel {
    protected int obliviousEngineVersion;

    public static UID post(ChannelManagerSession channelManagerSession, ChannelMessageToSend message, PRNGService prng) throws Exception {
        switch (message.getSendChannelInfo().getChannelType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return NetworkChannel.post(channelManagerSession, message, prng);
            }
            case 0: {
                return LocalChannel.post(channelManagerSession, message, prng);
            }
            case 5: {
                return UserInterfaceChannel.post(channelManagerSession, message, prng);
            }
            case 6: {
                return ServerQueryChannel.post(channelManagerSession, message, prng);
            }
        }
        return null;
    }

    public int getObliviousEngineVersion() {
        return this.obliviousEngineVersion;
    }
}

