/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.datatypes;

import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.channel.datatypes.NetworkChannel;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.AuthEncKeyAndChannelInfo;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.MessageToSend;
import io.olvid.engine.datatypes.containers.NetworkReceivedMessage;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.metamanager.EncryptionForIdentityDelegate;
import java.sql.SQLException;
import java.util.ArrayList;

public class AsymmetricChannel
extends NetworkChannel {
    private final UID toDeviceUid;
    private final Identity toIdentity;
    private final EncryptionForIdentityDelegate encryptionForIdentityDelegate;

    public AsymmetricChannel(UID toDeviceUid, Identity toIdentity, EncryptionForIdentityDelegate encryptionForIdentityDelegate) {
        this.toDeviceUid = toDeviceUid;
        this.toIdentity = toIdentity;
        this.encryptionForIdentityDelegate = encryptionForIdentityDelegate;
    }

    @Override
    public MessageToSend.Header wrapMessageKey(AuthEncKey messageKey, PRNGService prng, boolean partOfFullRatchetProtocol) {
        if (this.encryptionForIdentityDelegate == null) {
            return null;
        }
        EncryptedBytes wrappedKey = this.encryptionForIdentityDelegate.wrap(messageKey, this.toIdentity, prng);
        return new MessageToSend.Header(this.toDeviceUid, this.toIdentity, wrappedKey);
    }

    public static AuthEncKeyAndChannelInfo unwrapMessageKey(ChannelManagerSession channelManagerSession, NetworkReceivedMessage.Header header) throws SQLException {
        if (channelManagerSession.encryptionForIdentityDelegate == null) {
            return null;
        }
        AuthEncKey messageKey = channelManagerSession.encryptionForIdentityDelegate.unwrap(channelManagerSession.session, header.getWrappedKey(), header.getOwnedIdentity());
        if (messageKey == null) {
            return null;
        }
        return new AuthEncKeyAndChannelInfo(messageKey, ReceptionChannelInfo.createAsymmetricChannelInfo());
    }

    public static AsymmetricChannel[] acceptableChannelsForPosting(ChannelMessageToSend message, EncryptionForIdentityDelegate encryptionForIdentityDelegate) {
        if (message.getMessageType() != 0) {
            return new AsymmetricChannel[0];
        }
        switch (message.getSendChannelInfo().getChannelType()) {
            case 2: {
                UID[] remoteDeviceUids = message.getSendChannelInfo().getRemoteDeviceUids();
                ArrayList<AsymmetricChannel> channelList = new ArrayList<AsymmetricChannel>();
                for (UID deviceUid : remoteDeviceUids) {
                    channelList.add(new AsymmetricChannel(deviceUid, message.getSendChannelInfo().getToIdentity(), encryptionForIdentityDelegate));
                }
                return channelList.toArray(new AsymmetricChannel[0]);
            }
            case 4: {
                return new AsymmetricChannel[]{new AsymmetricChannel(Constants.BROADCAST_UID, message.getSendChannelInfo().getToIdentity(), encryptionForIdentityDelegate)};
            }
        }
        return new AsymmetricChannel[0];
    }
}

