/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.channel.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.channel.databases.ObliviousChannel;
import io.olvid.engine.channel.databases.ProvisionedKeyMaterial;
import io.olvid.engine.channel.datatypes.ChannelManagerSession;
import io.olvid.engine.channel.datatypes.RatchetingOutput;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Provision
implements ObvDatabase {
    static final String TABLE_NAME = "provision";
    private final ChannelManagerSession channelManagerSession;
    private final int fullRatchetingCount;
    static final String FULL_RATCHETING_COUNT = "full_ratcheting_count";
    private int selfRatchetingCount;
    static final String SELF_RATCHETING_COUNT = "self_ratcheting_count";
    private Seed seedForNextProvisionedReceiveKey;
    static final String SEED_FOR_NEXT_PROVISIONED_RECEIVE_KEY = "seed_for_next_provisioned_receive_key";
    private final int obliviousEngineVersion;
    static final String OBLIVIOUS_ENGINE_VERSION = "oblivious_engine_version";
    private final UID obliviousChannelCurrentDeviceUid;
    static final String OBLIVIOUS_CHANNEL_CURRENT_DEVICE_UID = "oblivious_channel_current_device_uid";
    private final UID obliviousChannelRemoteDeviceUid;
    static final String OBLIVIOUS_CHANNEL_REMOTE_DEVICE_UID = "oblivious_channel_remote_device_uid";
    private final Identity obliviousChannelRemoteIdentity;
    static final String OBLIVIOUS_CHANNEL_REMOTE_IDENTITY = "oblivious_channel_remote_identity";

    public int getFullRatchetingCount() {
        return this.fullRatchetingCount;
    }

    public UID getObliviousChannelCurrentDeviceUid() {
        return this.obliviousChannelCurrentDeviceUid;
    }

    public UID getObliviousChannelRemoteDeviceUid() {
        return this.obliviousChannelRemoteDeviceUid;
    }

    public Identity getObliviousChannelRemoteIdentity() {
        return this.obliviousChannelRemoteIdentity;
    }

    private void selfRatchet(int count) {
        for (int i = 0; i < count; ++i) {
            RatchetingOutput ratchetingOutput = ObliviousChannel.computeSelfRatchet(this.seedForNextProvisionedReceiveKey, this.obliviousEngineVersion);
            if (ratchetingOutput == null) {
                Logger.e("ObliviousChannel.computeSelfRatchet() returned null, this should never happen!");
                continue;
            }
            this.seedForNextProvisionedReceiveKey = ratchetingOutput.getRatchetedSeed();
            ProvisionedKeyMaterial.create(this.channelManagerSession, ratchetingOutput.getKeyId(), ratchetingOutput.getAuthEncKey(), this.selfRatchetingCount, this);
            ++this.selfRatchetingCount;
        }
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("Provision.selfRatchet", "UPDATE provision SET seed_for_next_provisioned_receive_key = ?, self_ratcheting_count = ?  WHERE full_ratcheting_count = ? AND oblivious_channel_current_device_uid = ? AND oblivious_channel_remote_device_uid = ? AND oblivious_channel_remote_identity = ?;");){
            statement.setBytes(1, this.seedForNextProvisionedReceiveKey.getBytes());
            statement.setInt(2, this.selfRatchetingCount);
            statement.setInt(3, this.fullRatchetingCount);
            statement.setBytes(4, this.obliviousChannelCurrentDeviceUid.getBytes());
            statement.setBytes(5, this.obliviousChannelRemoteDeviceUid.getBytes());
            statement.setBytes(6, this.obliviousChannelRemoteIdentity.getBytes());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public void selfRatchetIfRequired() {
        int remainingKeyMaterialCount = ProvisionedKeyMaterial.countNotExpiringProvisionedReceiveKey(this.channelManagerSession, this);
        if (remainingKeyMaterialCount < 50) {
            this.selfRatchet(50);
        }
    }

    public static void deleteAllEmpty(ChannelManagerSession channelManagerSession) {
        try (PreparedStatement statement = channelManagerSession.session.prepareStatement("Provision.deleteAllEmpty", "DELETE FROM provision AS p  WHERE NOT EXISTS ( SELECT 1 FROM provisioned_key_material WHERE provision_full_ratcheting_count = p.full_ratcheting_count AND provision_oblivious_channel_current_device_uid = p.oblivious_channel_current_device_uid AND provision_oblivious_channel_remote_device_uid = p.oblivious_channel_remote_device_uid AND provision_oblivious_channel_remote_identity = p.oblivious_channel_remote_identity)");){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public static Provision createOrReplace(ChannelManagerSession channelManagerSession, int fullRatchetingCount, ObliviousChannel obliviousChannel, Seed seedForNextProvisionedReceiveKey, int obliviousEngineVersion) {
        if (obliviousChannel == null || seedForNextProvisionedReceiveKey == null) {
            return null;
        }
        try {
            Provision provision = new Provision(channelManagerSession, fullRatchetingCount, obliviousChannel, seedForNextProvisionedReceiveKey, obliviousEngineVersion);
            provision.insert();
            provision.selfRatchet(100);
            return provision;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private Provision(ChannelManagerSession channelManagerSession, int fullRatchetingCount, ObliviousChannel obliviousChannel, Seed seedForNextProvisionedReceiveKey, int obliviousEngineVersion) {
        this.channelManagerSession = channelManagerSession;
        this.fullRatchetingCount = fullRatchetingCount;
        this.selfRatchetingCount = 0;
        this.seedForNextProvisionedReceiveKey = seedForNextProvisionedReceiveKey;
        this.obliviousEngineVersion = obliviousEngineVersion;
        this.obliviousChannelCurrentDeviceUid = obliviousChannel.getCurrentDeviceUid();
        this.obliviousChannelRemoteDeviceUid = obliviousChannel.getRemoteDeviceUid();
        this.obliviousChannelRemoteIdentity = obliviousChannel.getRemoteIdentity();
    }

    private Provision(ChannelManagerSession channelManagerSession, ResultSet res) throws SQLException {
        this.channelManagerSession = channelManagerSession;
        this.fullRatchetingCount = res.getInt(FULL_RATCHETING_COUNT);
        this.selfRatchetingCount = res.getInt(SELF_RATCHETING_COUNT);
        this.seedForNextProvisionedReceiveKey = new Seed(res.getBytes(SEED_FOR_NEXT_PROVISIONED_RECEIVE_KEY));
        this.obliviousEngineVersion = res.getInt(OBLIVIOUS_ENGINE_VERSION);
        this.obliviousChannelCurrentDeviceUid = new UID(res.getBytes(OBLIVIOUS_CHANNEL_CURRENT_DEVICE_UID));
        this.obliviousChannelRemoteDeviceUid = new UID(res.getBytes(OBLIVIOUS_CHANNEL_REMOTE_DEVICE_UID));
        try {
            this.obliviousChannelRemoteIdentity = Identity.of(res.getBytes(OBLIVIOUS_CHANNEL_REMOTE_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS provision (full_ratcheting_count INT NOT NULL, self_ratcheting_count INT NOT NULL, seed_for_next_provisioned_receive_key BLOB NOT NULL, oblivious_engine_version INT NOT NULL, oblivious_channel_current_device_uid BLOB NOT NULL, oblivious_channel_remote_device_uid BLOB NOT NULL, oblivious_channel_remote_identity BLOB NOT NULL, CONSTRAINT PK_provision PRIMARY KEY(full_ratcheting_count, oblivious_channel_current_device_uid, oblivious_channel_remote_device_uid, oblivious_channel_remote_identity), FOREIGN KEY (oblivious_channel_current_device_uid, oblivious_channel_remote_device_uid, oblivious_channel_remote_identity) REFERENCES oblivious_channel(current_device_uid, remote_device_uid, contact_identity) ON DELETE CASCADE);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 12 && newVersion >= 12) {
            try (Statement statement = session.createStatement();){
                statement.execute("DELETE FROM provision AS p  WHERE NOT EXISTS ( SELECT 1 FROM oblivious_channel  WHERE current_device_uid = p.oblivious_channel_current_device_uid AND remote_device_uid = p.oblivious_channel_remote_device_uid AND contact_identity = p.oblivious_channel_remote_identity )");
            }
            oldVersion = 12;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("Provision.insert", "INSERT OR REPLACE INTO provision VALUES (?,?,?,?,?, ?,?);");){
            statement.setInt(1, this.fullRatchetingCount);
            statement.setInt(2, this.selfRatchetingCount);
            statement.setBytes(3, this.seedForNextProvisionedReceiveKey.getBytes());
            statement.setInt(4, this.obliviousEngineVersion);
            statement.setBytes(5, this.obliviousChannelCurrentDeviceUid.getBytes());
            statement.setBytes(6, this.obliviousChannelRemoteDeviceUid.getBytes());
            statement.setBytes(7, this.obliviousChannelRemoteIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.channelManagerSession.session.prepareStatement("Provision.delete", "DELETE FROM provision WHERE full_ratcheting_count = ? AND oblivious_channel_current_device_uid = ? AND oblivious_channel_remote_device_uid = ? AND oblivious_channel_remote_identity = ?;");){
            statement.setInt(1, this.fullRatchetingCount);
            statement.setBytes(2, this.obliviousChannelCurrentDeviceUid.getBytes());
            statement.setBytes(3, this.obliviousChannelRemoteDeviceUid.getBytes());
            statement.setBytes(4, this.obliviousChannelRemoteIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Provision get(ChannelManagerSession channelManagerSession, int fullRatchetingCount, UID obliviousChannelCurrentDeviceUid, UID obliviousChannelRemoteDeviceUid, Identity obliviousChannelRemoteIdentity) {
        if (obliviousChannelCurrentDeviceUid == null || obliviousChannelRemoteDeviceUid == null || obliviousChannelRemoteIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = channelManagerSession.session.prepareStatement("Provision.get", "SELECT * FROM provision WHERE full_ratcheting_count = ? AND oblivious_channel_current_device_uid = ? AND oblivious_channel_remote_device_uid = ? AND oblivious_channel_remote_identity = ?;");){
            Provision provision;
            block19: {
                ResultSet res;
                block17: {
                    Provision provision2;
                    block18: {
                        statement.setInt(1, fullRatchetingCount);
                        statement.setBytes(2, obliviousChannelCurrentDeviceUid.getBytes());
                        statement.setBytes(3, obliviousChannelRemoteDeviceUid.getBytes());
                        statement.setBytes(4, obliviousChannelRemoteIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block17;
                            provision2 = new Provision(channelManagerSession, res);
                            if (res == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return provision2;
                }
                provision = null;
                if (res == null) break block19;
                res.close();
            }
            return provision;
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public void wasCommitted() {
    }
}

