/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.backup.tasks;

import io.olvid.engine.Logger;
import io.olvid.engine.backup.databases.DeviceBackupSeed;
import io.olvid.engine.backup.databases.ProfileBackupThreadId;
import io.olvid.engine.backup.datatypes.BackupManagerSession;
import io.olvid.engine.backup.datatypes.BackupManagerSessionFactory;
import io.olvid.engine.backup.datatypes.BackupTaskStatus;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.containers.BackupsV2ListItem;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.engine.types.sync.ObvProfileBackupSnapshot;
import io.olvid.engine.networkfetch.operations.StandaloneServerQueryOperation;
import java.security.InvalidKeyException;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;

public class ProfileBackupUploadTask {
    private final BackupManagerSessionFactory backupManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final Identity ownedIdentity;

    public ProfileBackupUploadTask(BackupManagerSessionFactory backupManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, Identity ownedIdentity) {
        this.backupManagerSessionFactory = backupManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.ownedIdentity = ownedIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackupTaskStatus execute() {
        try (BackupManagerSession backupManagerSession = this.backupManagerSessionFactory.getSession();){
            BackupTaskStatus backupTaskStatus;
            EncryptedBytes encryptedBackup;
            ObvProfileBackupSnapshot profileBackupSnapshot;
            Object rfc;
            DeviceBackupSeed deviceBackupSeed = DeviceBackupSeed.getActive(backupManagerSession);
            if (deviceBackupSeed == null) {
                Logger.w("ProfileBackupUploadTask no active DeviceBackupSeed");
                BackupTaskStatus backupTaskStatus2 = BackupTaskStatus.PERMANENT_FAILURE;
                return backupTaskStatus2;
            }
            ProfileBackupThreadId profileBackupThreadId = ProfileBackupThreadId.get(backupManagerSession, this.ownedIdentity);
            if (profileBackupThreadId == null) {
                profileBackupThreadId = ProfileBackupThreadId.create(backupManagerSession, this.ownedIdentity, backupManagerSession.prng);
                if (profileBackupThreadId == null) {
                    Logger.w("ProfileBackupUploadTask could not create a ProfileBackupThreadId for the given OwnedIdentity");
                    BackupTaskStatus backupTaskStatus3 = BackupTaskStatus.RETRIABLE_FAILURE;
                    return backupTaskStatus3;
                }
                backupManagerSession.session.commit();
            }
            String server = this.ownedIdentity.getServer();
            if (!backupManagerSession.identityDelegate.isActiveOwnedIdentity(backupManagerSession.session, this.ownedIdentity)) {
                Logger.w("ProfileBackupUploadTask started for an inactive OwnedIdentity");
                BackupTaskStatus backupTaskStatus4 = BackupTaskStatus.PERMANENT_FAILURE;
                return backupTaskStatus4;
            }
            BackupSeed backupSeed = backupManagerSession.identityDelegate.getOwnedIdentityBackupSeed(backupManagerSession.session, this.ownedIdentity);
            if (backupSeed == null) {
                Logger.w("ProfileBackupUploadTask could not find a BackupSeed for the given OwnedIdentity");
                BackupTaskStatus backupTaskStatus5 = BackupTaskStatus.PERMANENT_FAILURE;
                return backupTaskStatus5;
            }
            BackupSeed.DerivedKeysV2 derivedKeysV2 = backupSeed.deriveKeysV2();
            StandaloneServerQueryOperation standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2ListBackupsQuery(server, derivedKeysV2.backupKeyUid)), this.sslSocketFactory, this.userAgentOverride);
            OperationQueue queue = new OperationQueue();
            queue.queue(standaloneServerQueryOperation);
            queue.execute(1, "Engine-ProfileBackupUploadTask");
            queue.join();
            Long version = null;
            if (standaloneServerQueryOperation.isFinished()) {
                List<BackupsV2ListItem> backupsV2ListItems;
                try {
                    backupsV2ListItems = BackupsV2ListItem.manyOf(standaloneServerQueryOperation.getServerResponse().decodeList());
                }
                catch (Exception e) {
                    Logger.x(e);
                    BackupTaskStatus backupTaskStatus6 = BackupTaskStatus.RETRIABLE_FAILURE;
                    if (backupManagerSession == null) return backupTaskStatus6;
                    backupManagerSession.close();
                    return backupTaskStatus6;
                }
                for (Object backupsV2ListItem : backupsV2ListItems) {
                    if (!Objects.equals(backupsV2ListItem.threadId, profileBackupThreadId.getThreadId())) continue;
                    version = backupsV2ListItem.version;
                    break;
                }
                if (version == null) {
                    version = System.currentTimeMillis();
                }
            } else {
                rfc = standaloneServerQueryOperation.getReasonForCancel();
                if (rfc == null || rfc != 7) {
                    BackupTaskStatus e = BackupTaskStatus.RETRIABLE_FAILURE;
                    return e;
                }
            }
            if (version == null) {
                standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2CreateBackupQuery(server, derivedKeysV2.backupKeyUid, derivedKeysV2.authenticationKeyPair.getPublicKey())), this.sslSocketFactory, this.userAgentOverride);
                queue = new OperationQueue();
                queue.queue(standaloneServerQueryOperation);
                queue.execute(1, "Engine-ProfileBackupUploadTask");
                queue.join();
                if (!standaloneServerQueryOperation.isFinished()) {
                    rfc = BackupTaskStatus.RETRIABLE_FAILURE;
                    return rfc;
                }
                version = System.currentTimeMillis();
            }
            rfc = version;
            version = version + 1L;
            try {
                backupManagerSession.session.startTransaction();
                ObvBackupAndSyncDelegate identityBackupAndSyncDelegate = backupManagerSession.identityDelegate.getSyncDelegateWithinTransaction(backupManagerSession.session);
                profileBackupSnapshot = ObvProfileBackupSnapshot.get(this.ownedIdentity, identityBackupAndSyncDelegate, backupManagerSession.appBackupAndSyncDelegate);
            }
            catch (Exception e) {
                Object backupsV2ListItem;
                Logger.x(e);
                backupsV2ListItem = BackupTaskStatus.RETRIABLE_FAILURE;
                if (backupManagerSession == null) return backupsV2ListItem;
                backupManagerSession.close();
                return backupsV2ListItem;
            }
            finally {
                backupManagerSession.session.rollback();
            }
            Encoded plaintextContent = Encoded.of(profileBackupSnapshot.toEncodedDictionary(backupManagerSession.identityDelegate.getSyncDelegate(), backupManagerSession.appBackupAndSyncDelegate));
            byte[] paddedPlaintext = new byte[(plaintextContent.getBytes().length - 1 | 0x1FF) + 1];
            System.arraycopy(plaintextContent.getBytes(), 0, paddedPlaintext, 0, plaintextContent.getBytes().length);
            try {
                AuthEnc authEnc = Suite.getAuthEnc(derivedKeysV2.encryptionKey);
                encryptedBackup = authEnc.encrypt(derivedKeysV2.encryptionKey, paddedPlaintext, backupManagerSession.prng);
            }
            catch (InvalidKeyException e) {
                Logger.x(e);
                BackupTaskStatus backupTaskStatus7 = BackupTaskStatus.PERMANENT_FAILURE;
                if (backupManagerSession == null) return backupTaskStatus7;
                backupManagerSession.close();
                return backupTaskStatus7;
            }
            byte[] signaturePayload = Encoded.of(new Encoded[]{Encoded.of(derivedKeysV2.backupKeyUid), Encoded.of(profileBackupThreadId.getThreadId()), Encoded.of(version), Encoded.of(encryptedBackup)}).getBytes();
            byte[] signature = Signature.sign(Constants.SignatureContext.BACKUP_UPLOAD, signaturePayload, derivedKeysV2.authenticationKeyPair.getPrivateKey().getSignaturePrivateKey(), backupManagerSession.prng);
            standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2UploadBackupQuery(server, derivedKeysV2.backupKeyUid, profileBackupThreadId.getThreadId(), version, encryptedBackup, signature)), this.sslSocketFactory, this.userAgentOverride);
            queue = new OperationQueue();
            queue.queue(standaloneServerQueryOperation);
            queue.execute(1, "Engine-ProfileBackupUploadTask");
            queue.join();
            if (!standaloneServerQueryOperation.isFinished()) {
                backupTaskStatus = BackupTaskStatus.RETRIABLE_FAILURE;
                return backupTaskStatus;
            }
            backupTaskStatus = BackupTaskStatus.SUCCESS;
            return backupTaskStatus;
        }
        catch (Exception e) {
            Logger.x(e);
            return BackupTaskStatus.RETRIABLE_FAILURE;
        }
    }
}

