/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.backup.tasks;

import io.olvid.engine.backup.datatypes.BackupTaskStatus;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.StandaloneServerQueryOperation;
import javax.net.ssl.SSLSocketFactory;

public class ProfileBackupSnapshotDeleteTask {
    private final String server;
    private final BackupSeed profileBackupSeed;
    private final UID backupThreadId;
    private final long version;
    private final PRNGService prng;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;

    public ProfileBackupSnapshotDeleteTask(String server, BackupSeed profileBackupSeed, UID backupThreadId, long version, PRNGService prng, SSLSocketFactory sslSocketFactory, String userAgentOverride) {
        this.server = server;
        this.profileBackupSeed = profileBackupSeed;
        this.backupThreadId = backupThreadId;
        this.version = version;
        this.prng = prng;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
    }

    public BackupTaskStatus execute() {
        BackupSeed.DerivedKeysV2 derivedKeysV2 = this.profileBackupSeed.deriveKeysV2();
        byte[] signaturePayload = Encoded.of(new Encoded[]{Encoded.of(derivedKeysV2.backupKeyUid), Encoded.of(this.backupThreadId), Encoded.of(this.version)}).getBytes();
        byte[] signature = Signature.sign(Constants.SignatureContext.BACKUP_DELETE, signaturePayload, derivedKeysV2.authenticationKeyPair.getPrivateKey().getSignaturePrivateKey(), this.prng);
        StandaloneServerQueryOperation standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2DeleteBackupQuery(this.server, derivedKeysV2.backupKeyUid, this.backupThreadId, this.version, signature)), this.sslSocketFactory, this.userAgentOverride);
        OperationQueue queue = new OperationQueue();
        queue.queue(standaloneServerQueryOperation);
        queue.execute(1, "Engine-ProfileBackupSnapshotDeleteTask");
        queue.join();
        if (!standaloneServerQueryOperation.isFinished()) {
            return BackupTaskStatus.PERMANENT_FAILURE;
        }
        return BackupTaskStatus.SUCCESS;
    }
}

