/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.backup.tasks;

import io.olvid.engine.Logger;
import io.olvid.engine.backup.databases.DeviceBackupSeed;
import io.olvid.engine.backup.datatypes.BackupManagerSession;
import io.olvid.engine.backup.datatypes.BackupManagerSessionFactory;
import io.olvid.engine.backup.datatypes.BackupTaskStatus;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.containers.BackupsV2ListItem;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.engine.types.sync.ObvDeviceBackupSnapshot;
import io.olvid.engine.networkfetch.operations.StandaloneServerQueryOperation;
import java.security.InvalidKeyException;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;

public class DeviceBackupUploadTask {
    private final BackupManagerSessionFactory backupManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;

    public DeviceBackupUploadTask(BackupManagerSessionFactory backupManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride) {
        this.backupManagerSessionFactory = backupManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackupTaskStatus execute() {
        try (BackupManagerSession backupManagerSession = this.backupManagerSessionFactory.getSession();){
            BackupTaskStatus backupTaskStatus;
            EncryptedBytes encryptedBackup;
            ObvDeviceBackupSnapshot deviceBackupSnapshot;
            Object rfc;
            DeviceBackupSeed deviceBackupSeed = DeviceBackupSeed.getActive(backupManagerSession);
            if (deviceBackupSeed == null) {
                BackupTaskStatus backupTaskStatus2 = BackupTaskStatus.PERMANENT_FAILURE;
                return backupTaskStatus2;
            }
            if (backupManagerSession.identityDelegate.getOwnedIdentities(backupManagerSession.session).length == 0) {
                BackupTaskStatus backupTaskStatus3 = BackupTaskStatus.SUCCESS;
                return backupTaskStatus3;
            }
            String server = deviceBackupSeed.getServer();
            BackupSeed.DerivedKeysV2 derivedKeysV2 = deviceBackupSeed.getBackupSeed().deriveKeysV2();
            StandaloneServerQueryOperation standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2ListBackupsQuery(server, derivedKeysV2.backupKeyUid)), this.sslSocketFactory, this.userAgentOverride);
            OperationQueue queue = new OperationQueue();
            queue.queue(standaloneServerQueryOperation);
            queue.execute(1, "Engine-DeviceBackupUploadTask");
            queue.join();
            Long version = null;
            if (standaloneServerQueryOperation.isFinished()) {
                List<BackupsV2ListItem> backupsV2ListItems;
                try {
                    backupsV2ListItems = BackupsV2ListItem.manyOf(standaloneServerQueryOperation.getServerResponse().decodeList());
                }
                catch (Exception e) {
                    Logger.x(e);
                    BackupTaskStatus backupTaskStatus4 = BackupTaskStatus.RETRIABLE_FAILURE;
                    if (backupManagerSession == null) return backupTaskStatus4;
                    backupManagerSession.close();
                    return backupTaskStatus4;
                }
                for (Object backupsV2ListItem : backupsV2ListItems) {
                    if (!Objects.equals(backupsV2ListItem.threadId, Constants.DEVICE_BACKUP_THREAD_ID)) continue;
                    version = backupsV2ListItem.version;
                    break;
                }
                if (version == null) {
                    version = System.currentTimeMillis();
                }
            } else {
                rfc = standaloneServerQueryOperation.getReasonForCancel();
                if (rfc == null || rfc != 7) {
                    BackupTaskStatus e = BackupTaskStatus.RETRIABLE_FAILURE;
                    return e;
                }
            }
            if (version == null) {
                standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2CreateBackupQuery(server, derivedKeysV2.backupKeyUid, derivedKeysV2.authenticationKeyPair.getPublicKey())), this.sslSocketFactory, this.userAgentOverride);
                queue = new OperationQueue();
                queue.queue(standaloneServerQueryOperation);
                queue.execute(1, "Engine-DeviceBackupUploadTask");
                queue.join();
                if (!standaloneServerQueryOperation.isFinished()) {
                    rfc = BackupTaskStatus.RETRIABLE_FAILURE;
                    return rfc;
                }
                version = System.currentTimeMillis();
            }
            rfc = version;
            version = version + 1L;
            try {
                backupManagerSession.session.startTransaction();
                ObvBackupAndSyncDelegate identityBackupAndSyncDelegate = backupManagerSession.identityDelegate.getSyncDelegateWithinTransaction(backupManagerSession.session);
                deviceBackupSnapshot = ObvDeviceBackupSnapshot.get(identityBackupAndSyncDelegate, backupManagerSession.appBackupAndSyncDelegate);
            }
            catch (Exception e) {
                Object backupsV2ListItem;
                Logger.x(e);
                backupsV2ListItem = BackupTaskStatus.RETRIABLE_FAILURE;
                if (backupManagerSession == null) return backupsV2ListItem;
                backupManagerSession.close();
                return backupsV2ListItem;
            }
            finally {
                backupManagerSession.session.rollback();
            }
            Encoded plaintextContent = Encoded.of(deviceBackupSnapshot.toEncodedDictionary(backupManagerSession.identityDelegate.getSyncDelegate(), backupManagerSession.appBackupAndSyncDelegate));
            byte[] paddedPlaintext = new byte[(plaintextContent.getBytes().length - 1 | 0x1FF) + 1];
            System.arraycopy(plaintextContent.getBytes(), 0, paddedPlaintext, 0, plaintextContent.getBytes().length);
            try {
                AuthEnc authEnc = Suite.getAuthEnc(derivedKeysV2.encryptionKey);
                encryptedBackup = authEnc.encrypt(derivedKeysV2.encryptionKey, paddedPlaintext, backupManagerSession.prng);
            }
            catch (InvalidKeyException e) {
                Logger.x(e);
                BackupTaskStatus backupTaskStatus5 = BackupTaskStatus.PERMANENT_FAILURE;
                if (backupManagerSession == null) return backupTaskStatus5;
                backupManagerSession.close();
                return backupTaskStatus5;
            }
            byte[] signaturePayload = Encoded.of(new Encoded[]{Encoded.of(derivedKeysV2.backupKeyUid), Encoded.of(Constants.DEVICE_BACKUP_THREAD_ID), Encoded.of(version), Encoded.of(encryptedBackup)}).getBytes();
            byte[] signature = Signature.sign(Constants.SignatureContext.BACKUP_UPLOAD, signaturePayload, derivedKeysV2.authenticationKeyPair.getPrivateKey().getSignaturePrivateKey(), backupManagerSession.prng);
            standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2UploadBackupQuery(server, derivedKeysV2.backupKeyUid, Constants.DEVICE_BACKUP_THREAD_ID, version, encryptedBackup, signature)), this.sslSocketFactory, this.userAgentOverride);
            queue = new OperationQueue();
            queue.queue(standaloneServerQueryOperation);
            queue.execute(1, "Engine-DeviceBackupUploadTask");
            queue.join();
            if (!standaloneServerQueryOperation.isFinished()) {
                backupTaskStatus = BackupTaskStatus.RETRIABLE_FAILURE;
                return backupTaskStatus;
            }
            backupTaskStatus = BackupTaskStatus.SUCCESS;
            return backupTaskStatus;
        }
        catch (Exception e) {
            Logger.x(e);
            return BackupTaskStatus.RETRIABLE_FAILURE;
        }
    }
}

