/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.backup.tasks;

import io.olvid.engine.Logger;
import io.olvid.engine.backup.databases.DeviceBackupSeed;
import io.olvid.engine.backup.databases.ProfileBackupThreadId;
import io.olvid.engine.backup.datatypes.BackupManagerSession;
import io.olvid.engine.backup.datatypes.BackupManagerSessionFactory;
import io.olvid.engine.backup.datatypes.BackupTaskStatus;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.containers.BackupsV2ListItem;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.StandaloneServerQueryOperation;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;

public class DeviceBackupDeleteTask {
    private final BackupManagerSessionFactory backupManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final BackupSeed deviceBackupSeed;

    public DeviceBackupDeleteTask(BackupManagerSessionFactory backupManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, BackupSeed deviceBackupSeed) {
        this.backupManagerSessionFactory = backupManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.deviceBackupSeed = deviceBackupSeed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BackupTaskStatus execute() {
        try (BackupManagerSession backupManagerSession = this.backupManagerSessionFactory.getSession();){
            DeviceBackupSeed deviceBackupSeed = DeviceBackupSeed.get(backupManagerSession, this.deviceBackupSeed);
            if (deviceBackupSeed == null) {
                BackupTaskStatus backupTaskStatus = BackupTaskStatus.PERMANENT_FAILURE;
                return backupTaskStatus;
            }
            String deviceServer = deviceBackupSeed.getServer();
            BackupSeed.DerivedKeysV2 deviceDerivedKeysV2 = deviceBackupSeed.getBackupSeed().deriveKeysV2();
            StandaloneServerQueryOperation standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2ListBackupsQuery(deviceServer, deviceDerivedKeysV2.backupKeyUid)), this.sslSocketFactory, this.userAgentOverride);
            OperationQueue queue = new OperationQueue();
            queue.queue(standaloneServerQueryOperation);
            queue.execute(1, "Engine-DeviceBackupDeleteTask");
            queue.join();
            Long deviceVersion = null;
            if (standaloneServerQueryOperation.isFinished()) {
                List<BackupsV2ListItem> backupsV2ListItems;
                try {
                    backupsV2ListItems = BackupsV2ListItem.manyOf(standaloneServerQueryOperation.getServerResponse().decodeList());
                }
                catch (Exception e) {
                    Logger.x(e);
                    BackupTaskStatus backupTaskStatus = BackupTaskStatus.RETRIABLE_FAILURE;
                    if (backupManagerSession == null) return backupTaskStatus;
                    backupManagerSession.close();
                    return backupTaskStatus;
                }
                for (Object backupsV2ListItem : backupsV2ListItems) {
                    if (!Objects.equals(backupsV2ListItem.threadId, Constants.DEVICE_BACKUP_THREAD_ID)) continue;
                    deviceVersion = backupsV2ListItem.version;
                    break;
                }
            } else {
                Integer rfc = standaloneServerQueryOperation.getReasonForCancel();
                if (rfc == null || rfc != 7) {
                    BackupTaskStatus e = BackupTaskStatus.RETRIABLE_FAILURE;
                    return e;
                }
            }
            if (deviceVersion != null) {
                byte[] signaturePayload = Encoded.of(new Encoded[]{Encoded.of(deviceDerivedKeysV2.backupKeyUid), Encoded.of(Constants.DEVICE_BACKUP_THREAD_ID), Encoded.of(deviceVersion)}).getBytes();
                byte[] signature = Signature.sign(Constants.SignatureContext.BACKUP_DELETE, signaturePayload, deviceDerivedKeysV2.authenticationKeyPair.getPrivateKey().getSignaturePrivateKey(), backupManagerSession.prng);
                standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2DeleteBackupQuery(deviceServer, deviceDerivedKeysV2.backupKeyUid, Constants.DEVICE_BACKUP_THREAD_ID, deviceVersion, signature)), this.sslSocketFactory, this.userAgentOverride);
                queue = new OperationQueue();
                queue.queue(standaloneServerQueryOperation);
                queue.execute(1, "Engine-DeviceBackupDeleteTask");
                queue.join();
                if (!standaloneServerQueryOperation.isFinished()) {
                    Object backupsV2ListItem;
                    backupsV2ListItem = BackupTaskStatus.RETRIABLE_FAILURE;
                    return backupsV2ListItem;
                }
            }
            if (DeviceBackupSeed.getActive(backupManagerSession) == null) {
                for (ProfileBackupThreadId profileBackupThreadId : ProfileBackupThreadId.getAll(backupManagerSession)) {
                    BackupTaskStatus backupTaskStatus;
                    String server = profileBackupThreadId.getOwnedIdentity().getServer();
                    BackupSeed backupSeed = backupManagerSession.identityDelegate.getOwnedIdentityBackupSeed(backupManagerSession.session, profileBackupThreadId.getOwnedIdentity());
                    if (backupSeed == null) continue;
                    BackupSeed.DerivedKeysV2 derivedKeysV2 = backupSeed.deriveKeysV2();
                    standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2ListBackupsQuery(server, derivedKeysV2.backupKeyUid)), this.sslSocketFactory, this.userAgentOverride);
                    queue = new OperationQueue();
                    queue.queue(standaloneServerQueryOperation);
                    queue.execute(1, "Engine-DeviceBackupDeleteTask");
                    queue.join();
                    Long version = null;
                    if (standaloneServerQueryOperation.isFinished()) {
                        List<BackupsV2ListItem> backupsV2ListItems;
                        try {
                            backupsV2ListItems = BackupsV2ListItem.manyOf(standaloneServerQueryOperation.getServerResponse().decodeList());
                        }
                        catch (Exception e) {
                            Logger.x(e);
                            backupTaskStatus = BackupTaskStatus.RETRIABLE_FAILURE;
                            if (backupManagerSession == null) return backupTaskStatus;
                            backupManagerSession.close();
                            return backupTaskStatus;
                        }
                        for (BackupsV2ListItem backupsV2ListItem : backupsV2ListItems) {
                            if (!Objects.equals(backupsV2ListItem.threadId, profileBackupThreadId.getThreadId())) continue;
                            version = backupsV2ListItem.version;
                            break;
                        }
                    } else {
                        Integer rfc = standaloneServerQueryOperation.getReasonForCancel();
                        if (rfc == null || rfc != 7) {
                            BackupTaskStatus e = BackupTaskStatus.RETRIABLE_FAILURE;
                            return e;
                        }
                    }
                    if (version == null) continue;
                    byte[] signaturePayload = Encoded.of(new Encoded[]{Encoded.of(derivedKeysV2.backupKeyUid), Encoded.of(profileBackupThreadId.getThreadId()), Encoded.of(version)}).getBytes();
                    byte[] signature = Signature.sign(Constants.SignatureContext.BACKUP_DELETE, signaturePayload, derivedKeysV2.authenticationKeyPair.getPrivateKey().getSignaturePrivateKey(), backupManagerSession.prng);
                    standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2DeleteBackupQuery(server, derivedKeysV2.backupKeyUid, profileBackupThreadId.getThreadId(), version, signature)), this.sslSocketFactory, this.userAgentOverride);
                    queue = new OperationQueue();
                    queue.queue(standaloneServerQueryOperation);
                    queue.execute(1, "Engine-DeviceBackupDeleteTask");
                    queue.join();
                    if (standaloneServerQueryOperation.isFinished()) continue;
                    backupTaskStatus = BackupTaskStatus.RETRIABLE_FAILURE;
                    return backupTaskStatus;
                }
            }
            BackupTaskStatus backupTaskStatus = BackupTaskStatus.SUCCESS;
            return backupTaskStatus;
        }
        catch (Exception e) {
            Logger.x(e);
            return BackupTaskStatus.RETRIABLE_FAILURE;
        }
    }
}

