/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.backup.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.backup.datatypes.BackupManagerSession;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ProfileBackupThreadId
implements ObvDatabase {
    static final String TABLE_NAME = "profile_backup_thread_id";
    private final BackupManagerSession backupManagerSession;
    private final Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private final UID threadId;
    static final String THREAD_ID = "thread_id";
    private long nextBackupTimestamp;
    static final String NEXT_BACKUP_TIMESTAMP = "next_backup_timestamp";

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getThreadId() {
        return this.threadId;
    }

    public long getNextBackupTimestamp() {
        return this.nextBackupTimestamp;
    }

    public static ProfileBackupThreadId create(BackupManagerSession backupManagerSession, Identity ownedIdentity, PRNG prng) {
        if (ownedIdentity == null || prng == null) {
            return null;
        }
        try {
            UID threadId = new UID(prng);
            ProfileBackupThreadId profileBackupThreadId = new ProfileBackupThreadId(backupManagerSession, ownedIdentity, threadId);
            profileBackupThreadId.insert();
            return profileBackupThreadId;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private ProfileBackupThreadId(BackupManagerSession backupManagerSession, Identity ownedIdentity, UID threadId) {
        this.backupManagerSession = backupManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.threadId = threadId;
        this.nextBackupTimestamp = 0L;
    }

    private ProfileBackupThreadId(BackupManagerSession backupManagerSession, ResultSet res) throws SQLException {
        this.backupManagerSession = backupManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.threadId = new UID(res.getBytes(THREAD_ID));
        this.nextBackupTimestamp = res.getLong(NEXT_BACKUP_TIMESTAMP);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS profile_backup_thread_id (owned_identity BLOB PRIMARY KEY, thread_id BLOB NOT NULL, next_backup_timestamp BIGINT NOT NULL );");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 44 && newVersion >= 44) {
            Logger.d("CREATING `device_backup_seed` DATABASE FOR VERSION 44");
            try (Statement statement = session.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS profile_backup_thread_id ( owned_identity BLOB PRIMARY KEY,  thread_id BLOB NOT NULL,  next_backup_timestamp BIGINT NOT NULL );");
            }
            oldVersion = 44;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("ProfileBackupThreadId.insert", "INSERT INTO profile_backup_thread_id VALUES (?,?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.threadId.getBytes());
            statement.setLong(3, this.nextBackupTimestamp);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("ProfileBackupThreadId.delete", "DELETE FROM profile_backup_thread_id WHERE owned_identity = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public void setNextBackupTimestamp(long nextBackupTimestamp) throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("ProfileBackupThreadId.setNextBackupTimestamp", "UPDATE profile_backup_thread_id SET next_backup_timestamp = ?  WHERE owned_identity = ?;");){
            statement.setLong(1, nextBackupTimestamp);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.nextBackupTimestamp = nextBackupTimestamp;
        }
    }

    public static ProfileBackupThreadId get(BackupManagerSession backupManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement preparedStatement = backupManagerSession.session.prepareStatement("ProfileBackupThreadId.get", "SELECT * FROM profile_backup_thread_id WHERE owned_identity = ?;");){
            preparedStatement.setBytes(1, ownedIdentity.getBytes());
            ResultSet res = preparedStatement.executeQuery();
            if (res.next()) {
                ProfileBackupThreadId profileBackupThreadId = new ProfileBackupThreadId(backupManagerSession, res);
                return profileBackupThreadId;
            }
            ProfileBackupThreadId profileBackupThreadId = null;
            return profileBackupThreadId;
        }
    }

    public static List<ProfileBackupThreadId> getAll(BackupManagerSession backupManagerSession) throws SQLException {
        try (PreparedStatement preparedStatement = backupManagerSession.session.prepareStatement("ProfileBackupThreadId.getAll", "SELECT * FROM profile_backup_thread_id;");){
            ResultSet res = preparedStatement.executeQuery();
            ArrayList<ProfileBackupThreadId> list = new ArrayList<ProfileBackupThreadId>();
            while (res.next()) {
                list.add(new ProfileBackupThreadId(backupManagerSession, res));
            }
            ArrayList<ProfileBackupThreadId> arrayList = list;
            return arrayList;
        }
    }

    @Override
    public void wasCommitted() {
    }
}

