/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.backup.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.backup.datatypes.BackupManagerSession;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DeviceBackupSeed
implements ObvDatabase {
    static final String TABLE_NAME = "device_backup_seed";
    private final BackupManagerSession backupManagerSession;
    private final BackupSeed backupSeed;
    static final String BACKUP_SEED = "backup_seed";
    private final String server;
    static final String SERVER = "server";
    private boolean active;
    static final String ACTIVE = "active";
    private long nextBackupTimestamp;
    static final String NEXT_BACKUP_TIMESTAMP = "next_backup_timestamp";

    public BackupSeed getBackupSeed() {
        return this.backupSeed;
    }

    public String getServer() {
        return this.server;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getNextBackupTimestamp() {
        return this.nextBackupTimestamp;
    }

    public static DeviceBackupSeed create(BackupManagerSession backupManagerSession, BackupSeed backupSeed, String server) {
        if (backupSeed == null || server == null) {
            return null;
        }
        try {
            DeviceBackupSeed backupKey = new DeviceBackupSeed(backupManagerSession, backupSeed, server);
            backupKey.insert();
            return backupKey;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private DeviceBackupSeed(BackupManagerSession backupManagerSession, BackupSeed backupSeed, String server) {
        this.backupManagerSession = backupManagerSession;
        this.backupSeed = backupSeed;
        this.server = server;
        this.active = true;
        this.nextBackupTimestamp = 0L;
    }

    private DeviceBackupSeed(BackupManagerSession backupManagerSession, ResultSet res) throws SQLException {
        BackupSeed seed;
        this.backupManagerSession = backupManagerSession;
        try {
            seed = new BackupSeed(res.getBytes(BACKUP_SEED));
        }
        catch (Exception e) {
            Logger.x(e);
            seed = null;
        }
        this.backupSeed = seed;
        this.server = res.getString(SERVER);
        this.active = res.getBoolean(ACTIVE);
        this.nextBackupTimestamp = res.getLong(NEXT_BACKUP_TIMESTAMP);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS device_backup_seed (backup_seed BLOB PRIMARY KEY, server TEXT NOT NULL, active BIY NOT NULL, next_backup_timestamp BIGINT NOT NULL );");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 44 && newVersion >= 44) {
            Logger.d("CREATING `device_backup_seed` DATABASE FOR VERSION 44");
            try (Statement statement = session.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS device_backup_seed ( backup_seed BLOB PRIMARY KEY,  server TEXT NOT NULL,  active BIT NOT NULL, next_backup_timestamp BIGINT NOT NULL );");
            }
            oldVersion = 44;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("DeviceBackupSeed.insert", "INSERT INTO device_backup_seed VALUES (?,?,?,?);");){
            statement.setBytes(1, this.backupSeed.getBackupSeedBytes());
            statement.setString(2, this.server);
            statement.setBoolean(3, this.active);
            statement.setLong(4, this.nextBackupTimestamp);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("DeviceBackupSeed.delete", "DELETE FROM device_backup_seed WHERE backup_seed = ?;");){
            statement.setBytes(1, this.backupSeed.getBackupSeedBytes());
            statement.executeUpdate();
        }
    }

    public void markBackupKeyInactive() throws SQLException {
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("DeviceBackupSeed.markBackupKeyInactive", "UPDATE device_backup_seed SET active = ?  WHERE backup_seed = ?;");){
            statement.setBoolean(1, false);
            statement.setBytes(2, this.backupSeed.getBackupSeedBytes());
            statement.executeUpdate();
            this.active = false;
        }
    }

    public void setNextBackupTimestamp(long nextBackupTimestamp) throws SQLException {
        if (!this.active) {
            return;
        }
        try (PreparedStatement statement = this.backupManagerSession.session.prepareStatement("DeviceBackupSeed.setNextBackupTimestamp", "UPDATE device_backup_seed SET next_backup_timestamp = ?  WHERE backup_seed = ?;");){
            statement.setLong(1, nextBackupTimestamp);
            statement.setBytes(2, this.backupSeed.getBackupSeedBytes());
            statement.executeUpdate();
            this.nextBackupTimestamp = nextBackupTimestamp;
        }
    }

    public static DeviceBackupSeed get(BackupManagerSession backupManagerSession, BackupSeed backupSeed) throws SQLException {
        try (PreparedStatement preparedStatement = backupManagerSession.session.prepareStatement("DeviceBackupSeed.get", "SELECT * FROM device_backup_seed WHERE backup_seed = ?;");){
            preparedStatement.setBytes(1, backupSeed.getBackupSeedBytes());
            ResultSet res = preparedStatement.executeQuery();
            if (res.next()) {
                DeviceBackupSeed deviceBackupSeed = new DeviceBackupSeed(backupManagerSession, res);
                return deviceBackupSeed;
            }
            DeviceBackupSeed deviceBackupSeed = null;
            return deviceBackupSeed;
        }
    }

    public static DeviceBackupSeed getActive(BackupManagerSession backupManagerSession) throws SQLException {
        try (PreparedStatement preparedStatement = backupManagerSession.session.prepareStatement("DeviceBackupSeed.getActive", "SELECT * FROM device_backup_seed WHERE active = ?;");){
            preparedStatement.setBoolean(1, true);
            ResultSet res = preparedStatement.executeQuery();
            if (res.next()) {
                DeviceBackupSeed deviceBackupSeed = new DeviceBackupSeed(backupManagerSession, res);
                return deviceBackupSeed;
            }
            DeviceBackupSeed deviceBackupSeed = null;
            return deviceBackupSeed;
        }
    }

    public static DeviceBackupSeed[] getAllInactive(BackupManagerSession backupManagerSession) throws SQLException {
        try (PreparedStatement preparedStatement = backupManagerSession.session.prepareStatement("DeviceBackupSeed.getAllInactive", "SELECT * FROM device_backup_seed WHERE active = ?;");){
            preparedStatement.setBoolean(1, false);
            ResultSet res = preparedStatement.executeQuery();
            ArrayList<DeviceBackupSeed> list = new ArrayList<DeviceBackupSeed>();
            while (res.next()) {
                list.add(new DeviceBackupSeed(backupManagerSession, res));
            }
            DeviceBackupSeed[] deviceBackupSeedArray = list.toArray(new DeviceBackupSeed[0]);
            return deviceBackupSeedArray;
        }
    }

    @Override
    public void wasCommitted() {
    }
}

