/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.backup;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.backup.databases.Backup;
import io.olvid.engine.backup.databases.BackupKey;
import io.olvid.engine.backup.databases.DeviceBackupSeed;
import io.olvid.engine.backup.databases.ProfileBackupThreadId;
import io.olvid.engine.backup.datatypes.BackupManagerSession;
import io.olvid.engine.backup.datatypes.BackupManagerSessionFactory;
import io.olvid.engine.backup.tasks.DeviceBackupDeleteTask;
import io.olvid.engine.backup.tasks.DeviceBackupFetchTask;
import io.olvid.engine.backup.tasks.DeviceBackupUploadTask;
import io.olvid.engine.backup.tasks.ProfileBackupSnapshotDeleteTask;
import io.olvid.engine.backup.tasks.ProfileBackupUploadTask;
import io.olvid.engine.backup.tasks.ProfileBackupsFetchTask;
import io.olvid.engine.crypto.MAC;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.PublicKeyEncryption;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoExceptionSingleThreadExecutor;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.symmetric.MACKey;
import io.olvid.engine.engine.types.ObvBackupKeyInformation;
import io.olvid.engine.engine.types.ObvDeviceBackupForRestore;
import io.olvid.engine.engine.types.ObvProfileBackupsForRestore;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.metamanager.BackupDelegate;
import io.olvid.engine.metamanager.BackupV2Delegate;
import io.olvid.engine.metamanager.CreateSessionDelegate;
import io.olvid.engine.metamanager.IdentityDelegate;
import io.olvid.engine.metamanager.MetaManager;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.metamanager.ObvManager;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocketFactory;

public class BackupManager
implements BackupDelegate,
BackupV2Delegate,
BackupManagerSessionFactory,
ObvManager,
NotificationListener {
    private final ObvBackupAndSyncDelegate appBackupAndSyncDelegates;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final PRNGService prng;
    private final ObjectMapper jsonObjectMapper;
    private CreateSessionDelegate createSessionDelegate;
    private IdentityDelegate identityDelegate;
    private NotificationPostingDelegate notificationPostingDelegate;
    private final NoExceptionSingleThreadExecutor executor;
    private final ScheduledExecutorService autoBackupScheduler;
    private boolean autoBackupEnabled;
    private boolean autoBackupIsScheduled;
    private ScheduledFuture<?> scheduledAutoBackupTask;
    private final Object autoBackupSchedulerLock;
    private final Map<UidAndVersion, Map<String, String>> ongoingBackupMap;
    private final Map<UidAndVersion, ScheduledFuture<?>> ongoingBackupTimeoutMap;
    public static final String IDENTITY_BACKUP_TAG = "identity";
    public static final String APP_BACKUP_TAG = "app";
    public static final String[] ALL_BACKUP_TAGS = new String[]{"identity", "app"};
    public static final int BACKUP_SEED_VERIFICATION_STATUS_SUCCESS = 0;
    public static final int BACKUP_SEED_VERIFICATION_STATUS_TOO_SHORT = 1;
    public static final int BACKUP_SEED_VERIFICATION_STATUS_TOO_LONG = 2;
    public static final int BACKUP_SEED_VERIFICATION_STATUS_BAD_KEY = 3;
    private boolean deviceBackupsActive;
    private final Set<ScheduledBackup> scheduledBackups;
    private Long nextScheduledBackupTimestamp;

    public BackupManager(MetaManager metaManager, ObvBackupAndSyncDelegate appBackupAndSyncDelegates, SSLSocketFactory sslSocketFactory, String userAgentOverride, PRNGService prng, ObjectMapper jsonObjectMapper) {
        this.appBackupAndSyncDelegates = appBackupAndSyncDelegates;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.prng = prng;
        this.jsonObjectMapper = jsonObjectMapper;
        this.executor = new NoExceptionSingleThreadExecutor("BackupManager executor");
        this.autoBackupScheduler = Executors.newScheduledThreadPool(1);
        this.autoBackupEnabled = false;
        this.autoBackupIsScheduled = false;
        this.autoBackupSchedulerLock = new Object();
        this.ongoingBackupMap = new HashMap<UidAndVersion, Map<String, String>>();
        this.ongoingBackupTimeoutMap = new HashMap();
        this.deviceBackupsActive = false;
        this.scheduledBackups = new HashSet<ScheduledBackup>();
        this.nextScheduledBackupTimestamp = null;
        metaManager.requestDelegate(this, CreateSessionDelegate.class);
        metaManager.requestDelegate(this, IdentityDelegate.class);
        metaManager.requestDelegate(this, NotificationPostingDelegate.class);
        metaManager.requestDelegate(this, NotificationListeningDelegate.class);
        metaManager.registerImplementedDelegates(this);
    }

    @Override
    public int initialQueueingPriority() {
        return 40;
    }

    @Override
    public void initialisationComplete() {
        BackupManagerSession backupManagerSession;
        try {
            backupManagerSession = this.getSession();
            try {
                for (BackupKey backupKey : BackupKey.getAll(backupManagerSession)) {
                    Backup.cleanup(backupManagerSession, backupKey.getUid(), backupKey.getUploadedBackupVersion(), backupKey.getExportedBackupVersion(), backupKey.getLatestBackupVersion());
                }
                backupManagerSession.session.commit();
            }
            finally {
                if (backupManagerSession != null) {
                    backupManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        try {
            backupManagerSession = this.getSession();
            try {
                DeviceBackupSeed deviceBackupSeed = DeviceBackupSeed.getActive(backupManagerSession);
                if (deviceBackupSeed != null) {
                    this.scheduleDeviceAndAllProfilesBackup(backupManagerSession, deviceBackupSeed);
                }
                for (DeviceBackupSeed inactiveDeviceBackupSeed : DeviceBackupSeed.getAllInactive(backupManagerSession)) {
                    this.cleanUpDeviceBackups(inactiveDeviceBackupSeed.getBackupSeed());
                }
            }
            finally {
                if (backupManagerSession != null) {
                    backupManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    public void setDelegate(CreateSessionDelegate createSessionDelegate) {
        this.createSessionDelegate = createSessionDelegate;
        try (BackupManagerSession backupManagerSession = this.getSession();){
            Backup.createTable(backupManagerSession.session);
            BackupKey.createTable(backupManagerSession.session);
            DeviceBackupSeed.createTable(backupManagerSession.session);
            ProfileBackupThreadId.createTable(backupManagerSession.session);
            backupManagerSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
            throw new RuntimeException("Unable to create backup databases");
        }
    }

    public static void upgradeTables(Session session, int oldVersion, int newVersion) throws SQLException {
        Backup.upgradeTable(session, oldVersion, newVersion);
        BackupKey.upgradeTable(session, oldVersion, newVersion);
        DeviceBackupSeed.upgradeTable(session, oldVersion, newVersion);
        ProfileBackupThreadId.upgradeTable(session, oldVersion, newVersion);
    }

    public void setDelegate(IdentityDelegate identityDelegate) {
        this.identityDelegate = identityDelegate;
    }

    public void setDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void setDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        notificationListeningDelegate.addListener("identity_manager_notification_database_content_changed", this);
        notificationListeningDelegate.addListener("backup_notification_device_backup_needed", this);
        notificationListeningDelegate.addListener("backup_notification_profile_backup_needed", this);
    }

    @Override
    public BackupManagerSession getSession() throws SQLException {
        if (this.createSessionDelegate == null) {
            throw new SQLException("No CreateSessionDelegate was set in BackupManager.");
        }
        return new BackupManagerSession(this.createSessionDelegate.getSession(), this.notificationPostingDelegate, this.identityDelegate, this.appBackupAndSyncDelegates, this.jsonObjectMapper, this.prng);
    }

    public ObjectMapper getJsonObjectMapper() {
        return this.jsonObjectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryScheduledNetworkTasks() {
        Set<ScheduledBackup> set = this.scheduledBackups;
        synchronized (set) {
            for (ScheduledBackup scheduledBackup : this.scheduledBackups) {
                scheduledBackup.clearFailedAttemptCounts();
            }
            this.executeScheduledBackupsThatReachedTheirTimestamp();
        }
    }

    private void scheduleDeviceAndAllProfilesBackup(BackupManagerSession backupManagerSession, DeviceBackupSeed deviceBackupSeed) throws SQLException {
        this.deviceBackupsActive = true;
        this.scheduleDeviceBackup(deviceBackupSeed.getNextBackupTimestamp());
        boolean commitNeeded = false;
        List<ProfileBackupThreadId> profileBackupThreadIds = ProfileBackupThreadId.getAll(backupManagerSession);
        HashSet<Identity> ownedIdentities = new HashSet<Identity>(Arrays.asList(this.identityDelegate.getOwnedIdentities(backupManagerSession.session)));
        for (ProfileBackupThreadId profileBackupThreadId : profileBackupThreadIds) {
            if (ownedIdentities.remove(profileBackupThreadId.getOwnedIdentity())) continue;
            Logger.w("Found a ProfileBackupThreadId for an unknown OwnedIdentity --> cleaning it up!");
            profileBackupThreadId.delete();
            commitNeeded = true;
        }
        for (Identity ownedIdentity : ownedIdentities) {
            Logger.i("Found an ownedIdentity without a ProfileBackupThreadId --> creating one!");
            ProfileBackupThreadId profileBackupThreadId = ProfileBackupThreadId.create(backupManagerSession, ownedIdentity, this.prng);
            if (profileBackupThreadId == null) continue;
            profileBackupThreadIds.add(profileBackupThreadId);
            commitNeeded = true;
        }
        if (commitNeeded) {
            backupManagerSession.session.commit();
        }
        for (ProfileBackupThreadId profileBackupThreadId : profileBackupThreadIds) {
            this.scheduleProfileBackup(profileBackupThreadId.getOwnedIdentity(), profileBackupThreadId.getNextBackupTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleDeviceBackup(long timestamp) {
        Set<ScheduledBackup> set = this.scheduledBackups;
        synchronized (set) {
            for (ScheduledBackup scheduledBackup : this.scheduledBackups) {
                if (scheduledBackup.ownedIdentity != null) continue;
                if (scheduledBackup.timestamp < timestamp) {
                    return;
                }
                this.scheduledBackups.remove(scheduledBackup);
                break;
            }
            this.insertScheduledBackup(new ScheduledBackup(null, timestamp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleProfileBackup(Identity ownedIdentity, long timestamp) {
        Set<ScheduledBackup> set = this.scheduledBackups;
        synchronized (set) {
            for (ScheduledBackup scheduledBackup : this.scheduledBackups) {
                if (!Objects.equals(scheduledBackup.ownedIdentity, ownedIdentity)) continue;
                if (scheduledBackup.timestamp < timestamp) {
                    return;
                }
                this.scheduledBackups.remove(scheduledBackup);
                break;
            }
            this.insertScheduledBackup(new ScheduledBackup(ownedIdentity, timestamp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelScheduledDeviceAndProfileBackups() {
        Set<ScheduledBackup> set = this.scheduledBackups;
        synchronized (set) {
            this.scheduledBackups.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertScheduledBackup(ScheduledBackup scheduledBackup) {
        Set<ScheduledBackup> set = this.scheduledBackups;
        synchronized (set) {
            this.scheduledBackups.add(scheduledBackup);
            if (scheduledBackup.scheduledTimestamp > System.currentTimeMillis()) {
                if (this.nextScheduledBackupTimestamp == null || scheduledBackup.scheduledTimestamp < this.nextScheduledBackupTimestamp) {
                    this.nextScheduledBackupTimestamp = scheduledBackup.scheduledTimestamp;
                    this.autoBackupScheduler.schedule(this::executeScheduledBackupsThatReachedTheirTimestamp, scheduledBackup.scheduledTimestamp - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                }
            } else {
                this.executeScheduledBackupsThatReachedTheirTimestamp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScheduledBackupsThatReachedTheirTimestamp() {
        Set<ScheduledBackup> set = this.scheduledBackups;
        synchronized (set) {
            long now = System.currentTimeMillis();
            Long nextTimestamp = null;
            for (ScheduledBackup scheduledBackup : new ArrayList<ScheduledBackup>(this.scheduledBackups)) {
                if (scheduledBackup.scheduledTimestamp < now) {
                    this.scheduledBackups.remove(scheduledBackup);
                    this.initiateBackup(scheduledBackup);
                    continue;
                }
                if (nextTimestamp != null && scheduledBackup.scheduledTimestamp >= nextTimestamp) continue;
                nextTimestamp = scheduledBackup.scheduledTimestamp;
            }
            if (nextTimestamp != null) {
                this.nextScheduledBackupTimestamp = nextTimestamp;
                this.autoBackupScheduler.schedule(this::executeScheduledBackupsThatReachedTheirTimestamp, nextTimestamp - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private void initiateBackup(ScheduledBackup scheduledBackup) {
        this.executor.execute(() -> {
            if (scheduledBackup.ownedIdentity == null) {
                DeviceBackupUploadTask deviceBackupUploadTask = new DeviceBackupUploadTask(this, this.sslSocketFactory, this.userAgentOverride);
                switch (deviceBackupUploadTask.execute()) {
                    case SUCCESS: {
                        try (BackupManagerSession backupManagerSession = this.getSession();){
                            DeviceBackupSeed deviceBackupSeed = DeviceBackupSeed.getActive(backupManagerSession);
                            if (deviceBackupSeed != null) {
                                long nextBackupTimestamp = System.currentTimeMillis() + 2592000000L;
                                deviceBackupSeed.setNextBackupTimestamp(nextBackupTimestamp);
                                backupManagerSession.session.commit();
                                this.scheduleDeviceBackup(nextBackupTimestamp);
                            }
                            break;
                        }
                        catch (Exception e) {
                            Logger.x(e);
                            break;
                        }
                    }
                    case RETRIABLE_FAILURE: {
                        Set<ScheduledBackup> e = this.scheduledBackups;
                        synchronized (e) {
                            scheduledBackup.rescheduleAfterRetriableFailure();
                            this.insertScheduledBackup(scheduledBackup);
                            break;
                        }
                    }
                }
            } else {
                ProfileBackupUploadTask profileBackupUploadTask = new ProfileBackupUploadTask(this, this.sslSocketFactory, this.userAgentOverride, scheduledBackup.ownedIdentity);
                switch (profileBackupUploadTask.execute()) {
                    case SUCCESS: {
                        try (BackupManagerSession backupManagerSession = this.getSession();){
                            ProfileBackupThreadId profileBackupThreadId = ProfileBackupThreadId.get(backupManagerSession, scheduledBackup.ownedIdentity);
                            if (profileBackupThreadId != null) {
                                long nextBackupTimestamp = System.currentTimeMillis() + 86400000L;
                                profileBackupThreadId.setNextBackupTimestamp(nextBackupTimestamp);
                                backupManagerSession.session.commit();
                                this.scheduleProfileBackup(scheduledBackup.ownedIdentity, nextBackupTimestamp);
                            }
                        }
                        catch (Exception e) {
                            Logger.x(e);
                        }
                        break;
                    }
                    case RETRIABLE_FAILURE: {
                        Set<ScheduledBackup> set = this.scheduledBackups;
                        synchronized (set) {
                            scheduledBackup.rescheduleAfterRetriableFailure();
                            this.insertScheduledBackup(scheduledBackup);
                            break;
                        }
                    }
                }
            }
        });
    }

    private void cleanUpDeviceBackups(BackupSeed backupSeed) {
        this.executor.execute(() -> {
            DeviceBackupDeleteTask deviceBackupDeleteTask = new DeviceBackupDeleteTask(this, this.sslSocketFactory, this.userAgentOverride, backupSeed);
            switch (deviceBackupDeleteTask.execute()) {
                case SUCCESS: {
                    try (BackupManagerSession backupManagerSession = this.getSession();){
                        DeviceBackupSeed deviceBackupSeed = DeviceBackupSeed.get(backupManagerSession, backupSeed);
                        if (deviceBackupSeed != null && !deviceBackupSeed.isActive()) {
                            deviceBackupSeed.delete();
                            backupManagerSession.session.commit();
                        }
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                    break;
                }
                case RETRIABLE_FAILURE: {
                    this.autoBackupScheduler.schedule(() -> this.cleanUpDeviceBackups(backupSeed), 5L, TimeUnit.MINUTES);
                    break;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateDeviceBackupSeed(String server) throws Exception {
        try (BackupManagerSession backupManagerSession = this.getSession();){
            BackupManager backupManager = this;
            synchronized (backupManager) {
                block13: {
                    DeviceBackupSeed deviceBackupSeed = DeviceBackupSeed.getActive(backupManagerSession);
                    if (deviceBackupSeed != null) {
                        throw new Exception("A DeviceBackupSeed already exists");
                    }
                    deviceBackupSeed = DeviceBackupSeed.create(backupManagerSession, BackupSeed.generate(this.prng), server);
                    if (deviceBackupSeed == null) break block13;
                    for (ProfileBackupThreadId profileBackupThreadId : ProfileBackupThreadId.getAll(backupManagerSession)) {
                        profileBackupThreadId.setNextBackupTimestamp(0L);
                    }
                    backupManagerSession.session.commit();
                    this.scheduleDeviceAndAllProfilesBackup(backupManagerSession, deviceBackupSeed);
                    String string = deviceBackupSeed.getBackupSeed().toString();
                    return string;
                }
            }
        }
        return null;
    }

    @Override
    public String getCurrentDeviceBackupSeed() throws Exception {
        try (BackupManagerSession backupManagerSession = this.getSession();){
            DeviceBackupSeed deviceBackupSeed = DeviceBackupSeed.getActive(backupManagerSession);
            if (deviceBackupSeed != null) {
                String string = deviceBackupSeed.getBackupSeed().toString();
                return string;
            }
        }
        return null;
    }

    @Override
    public void deleteDeviceBackupSeed(BackupSeed backupSeed) throws Exception {
        try (BackupManagerSession backupManagerSession = this.getSession();){
            DeviceBackupSeed deviceBackupSeed = DeviceBackupSeed.getActive(backupManagerSession);
            if (deviceBackupSeed != null && deviceBackupSeed.getBackupSeed().equals(backupSeed)) {
                deviceBackupSeed.markBackupKeyInactive();
                backupManagerSession.session.commit();
                this.cancelScheduledDeviceAndProfileBackups();
                this.cleanUpDeviceBackups(deviceBackupSeed.getBackupSeed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean backupDeviceAndProfilesNow() {
        try (BackupManagerSession backupManagerSession = this.getSession();){
            if (DeviceBackupSeed.getActive(backupManagerSession) == null) return false;
            this.scheduleDeviceBackup(0L);
            HashSet<Identity> ownedIdentities = new HashSet<Identity>();
            for (Identity ownedIdentity : backupManagerSession.identityDelegate.getOwnedIdentities(backupManagerSession.session)) {
                this.scheduleProfileBackup(ownedIdentity, 0L);
                ownedIdentities.add(ownedIdentity);
            }
            Object lock = new Object();
            AtomicBoolean success = new AtomicBoolean(false);
            this.executor.execute(() -> {
                try {
                    boolean allGood = true;
                    Set<ScheduledBackup> set = this.scheduledBackups;
                    synchronized (set) {
                        for (ScheduledBackup scheduledBackup : this.scheduledBackups) {
                            if (scheduledBackup.failedAttemptCounts == 0 || scheduledBackup.ownedIdentity != null && !ownedIdentities.contains(scheduledBackup.ownedIdentity)) continue;
                            allGood = false;
                            break;
                        }
                    }
                    success.set(allGood);
                }
                finally {
                    Object object = lock;
                    synchronized (object) {
                        lock.notify();
                    }
                }
            });
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            boolean bl = success.get();
            return bl;
        }
        catch (SQLException e) {
            Logger.x(e);
        }
        return false;
    }

    @Override
    public ObvDeviceBackupForRestore fetchDeviceBackup(String server, BackupSeed backupSeed) {
        DeviceBackupFetchTask deviceBackupFetchTask = new DeviceBackupFetchTask(server, backupSeed, this, this.sslSocketFactory, this.userAgentOverride);
        switch (deviceBackupFetchTask.execute()) {
            case SUCCESS: {
                return deviceBackupFetchTask.getObvDeviceBackupForRestore();
            }
            case RETRIABLE_FAILURE: {
                if (deviceBackupFetchTask.getObvDeviceBackupForRestore() == null) break;
                return deviceBackupFetchTask.getObvDeviceBackupForRestore();
            }
            case PERMANENT_FAILURE: {
                if (deviceBackupFetchTask.getObvDeviceBackupForRestore() != null) {
                    return deviceBackupFetchTask.getObvDeviceBackupForRestore();
                }
                return new ObvDeviceBackupForRestore(ObvDeviceBackupForRestore.Status.PERMANENT_ERROR, null, null);
            }
        }
        return new ObvDeviceBackupForRestore(ObvDeviceBackupForRestore.Status.ERROR, null, null);
    }

    @Override
    public ObvProfileBackupsForRestore fetchProfileBackups(String server, BackupSeed backupSeed) {
        ProfileBackupsFetchTask profileBackupsFetchTask = new ProfileBackupsFetchTask(server, backupSeed, this, this.sslSocketFactory, this.userAgentOverride);
        switch (profileBackupsFetchTask.execute()) {
            case SUCCESS: {
                return profileBackupsFetchTask.getObvProfileBackupsForRestore();
            }
            case RETRIABLE_FAILURE: {
                if (profileBackupsFetchTask.getObvProfileBackupsForRestore() == null) break;
                return profileBackupsFetchTask.getObvProfileBackupsForRestore();
            }
            case PERMANENT_FAILURE: {
                if (profileBackupsFetchTask.getObvProfileBackupsForRestore() != null) {
                    return profileBackupsFetchTask.getObvProfileBackupsForRestore();
                }
                return new ObvProfileBackupsForRestore(ObvProfileBackupsForRestore.Status.PERMANENT_ERROR, null, null);
            }
        }
        return new ObvProfileBackupsForRestore(ObvProfileBackupsForRestore.Status.ERROR, null, null);
    }

    @Override
    public boolean deleteProfileBackupSnapshot(String server, BackupSeed backupSeed, UID backupThreadId, long version) {
        ProfileBackupSnapshotDeleteTask profileBackupSnapshotDeleteTask = new ProfileBackupSnapshotDeleteTask(server, backupSeed, backupThreadId, version, this.prng, this.sslSocketFactory, this.userAgentOverride);
        switch (profileBackupSnapshotDeleteTask.execute()) {
            case SUCCESS: {
                return true;
            }
            case RETRIABLE_FAILURE: 
            case PERMANENT_FAILURE: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void stopLegacyBackups() {
        this.autoBackupEnabled = false;
        try (BackupManagerSession backupManagerSession = this.getSession();){
            BackupKey.deleteAll(backupManagerSession);
            backupManagerSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void setAutoBackupEnabled(boolean enabled, boolean initiateBackupNowIfNeeded) {
        this.autoBackupEnabled = enabled;
        if (!enabled || !initiateBackupNowIfNeeded) {
            return;
        }
        try (BackupManagerSession backupManagerSession = this.getSession();){
            BackupKey backupKey;
            Backup lastUploadedBackup;
            BackupKey[] backupKeys = BackupKey.getAll(backupManagerSession);
            if (backupKeys.length == 1 && ((lastUploadedBackup = (backupKey = backupKeys[0]).getUploadedBackup()) == null || backupKey.getLatestBackupVersion() != null && backupKey.getLatestBackupVersion() > lastUploadedBackup.getVersion() || System.currentTimeMillis() - lastUploadedBackup.getStatusChangeTimestamp() > 86400000L || lastUploadedBackup.getBackupJsonVersion() != 0)) {
                this.scheduleBackupForUploadIfNeeded(true);
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public void scheduleBackupIfNeeded() {
        this.scheduleBackupForUploadIfNeeded(false);
    }

    @Override
    public void initiateBackup(boolean forExpert) {
        this.executor.execute(() -> {
            try (BackupManagerSession backupManagerSession = this.getSession();){
                BackupKey[] backupKeys = BackupKey.getAll(backupManagerSession);
                if (backupKeys.length == 0) {
                    throw new Exception("No BackupKey generated!");
                }
                if (backupKeys.length > 1) {
                    throw new Exception("Multiple BackupKey generated, this should never occur!");
                }
                BackupKey backupKey = backupKeys[0];
                Logger.d("Initiating a backup");
                backupManagerSession.session.startTransaction();
                Integer newVersion = backupKey.getLatestBackupVersion();
                if (newVersion == null) {
                    newVersion = 0;
                } else {
                    Integer n = newVersion;
                    newVersion = newVersion + 1;
                }
                Backup backup = Backup.createOngoingBackup(backupManagerSession, backupKey.getUid(), newVersion, forExpert);
                if (backup == null) {
                    throw new Exception("BackupManager failed to create ongoing backup in DB");
                }
                backupKey.setLatestBackupVersion(newVersion);
                backupManagerSession.session.commit();
                UidAndVersion uidAndVersion = new UidAndVersion(backupKey.getUid(), newVersion);
                this.ongoingBackupMap.remove(uidAndVersion);
                this.ongoingBackupMap.put(uidAndVersion, new HashMap());
                ScheduledFuture<?> previousTimeout = this.ongoingBackupTimeoutMap.remove(uidAndVersion);
                if (previousTimeout != null) {
                    previousTimeout.cancel(false);
                }
                int finalNewVersion = newVersion;
                this.ongoingBackupTimeoutMap.put(uidAndVersion, this.autoBackupScheduler.schedule(() -> this.backupFailed("TIMEOUT", backupKey.getUid(), finalNewVersion), 30000L, TimeUnit.MILLISECONDS));
                this.identityDelegate.initiateBackup(this, IDENTITY_BACKUP_TAG, backupKey.getUid(), newVersion);
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("backup_uid", backupKey.getUid());
                userInfo.put("version", newVersion);
                this.notificationPostingDelegate.postNotification("backup_notification_app_backup_initiation_request", userInfo);
            }
            catch (Exception e) {
                Logger.x(e);
            }
        });
    }

    @Override
    public void backupFailed(String tag, UID backupKeyUid, int version) {
        this.executor.execute(() -> {
            Logger.w("Backup failed for tag: " + tag);
            UidAndVersion uidAndVersion = new UidAndVersion(backupKeyUid, version);
            this.ongoingBackupMap.remove(uidAndVersion);
            ScheduledFuture<?> timeout = this.ongoingBackupTimeoutMap.remove(uidAndVersion);
            if (timeout != null) {
                timeout.cancel(false);
            }
            try (BackupManagerSession backupManagerSession = this.getSession();){
                Backup backup = Backup.get(backupManagerSession, backupKeyUid, version);
                if (backup != null && backup.getStatus() == 0) {
                    backup.setFailed();
                    if (backup.isForExport()) {
                        this.notificationPostingDelegate.postNotification("backup_notification_backup_for_export_failed", Collections.emptyMap());
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        });
    }

    @Override
    public void backupSuccess(String tag, UID backupKeyUid, int version, String backupContent) {
        this.executor.execute(() -> {
            try (BackupManagerSession backupManagerSession = this.getSession();){
                BackupKey backupKey = BackupKey.get(backupManagerSession, backupKeyUid);
                if (backupKey == null) {
                    throw new Exception("BackupKey not found");
                }
                Backup backup = Backup.get(backupManagerSession, backupKeyUid, version);
                if (backup == null || backup.getStatus() != 0) {
                    throw new Exception("Ongoing Backup not found");
                }
                UidAndVersion uidAndVersion = new UidAndVersion(backupKeyUid, version);
                Map<String, String> backupParts = this.ongoingBackupMap.get(uidAndVersion);
                if (backupParts == null) {
                    throw new Exception("Unable to find ongoing backup parts map");
                }
                if (backupParts.containsKey(tag)) {
                    throw new Exception("Received 2 backups for the same tag!");
                }
                backupParts.put(tag, backupContent);
                boolean complete = true;
                for (String backupTag : ALL_BACKUP_TAGS) {
                    if (backupParts.containsKey(backupTag)) continue;
                    complete = false;
                    break;
                }
                if (complete) {
                    HashMap<String, Object> userInfo;
                    Pojo_0 pojo = new Pojo_0();
                    EnginePojo_0 enginePojo = new EnginePojo_0();
                    enginePojo.identity_manager = backupParts.get(IDENTITY_BACKUP_TAG);
                    pojo.engine = enginePojo;
                    pojo.app = backupParts.get(APP_BACKUP_TAG);
                    pojo.backup_json_version = backup.getBackupJsonVersion();
                    pojo.backup_timestamp = System.currentTimeMillis();
                    String fullBackupContent = this.jsonObjectMapper.writeValueAsString((Object)pojo);
                    EncryptionPublicKey encryptionPublicKey = backupKey.getEncryptionPublicKey();
                    MACKey macKey = backupKey.getMacKey();
                    EncryptedBytes encryptedBackup = Suite.getPublicKeyEncryption(encryptionPublicKey).encrypt(encryptionPublicKey, fullBackupContent.getBytes(StandardCharsets.UTF_8), this.prng);
                    byte[] mac = Suite.getMAC(macKey).digest(macKey, encryptedBackup.getBytes());
                    byte[] macedEncryptedBackup = new byte[encryptedBackup.getBytes().length + mac.length];
                    System.arraycopy(encryptedBackup.getBytes(), 0, macedEncryptedBackup, 0, encryptedBackup.getBytes().length);
                    System.arraycopy(mac, 0, macedEncryptedBackup, encryptedBackup.getBytes().length, mac.length);
                    backup.setReady(macedEncryptedBackup);
                    this.ongoingBackupMap.remove(uidAndVersion);
                    ScheduledFuture<?> timeout = this.ongoingBackupTimeoutMap.remove(uidAndVersion);
                    if (timeout != null) {
                        timeout.cancel(false);
                    }
                    if (backup.isForExport()) {
                        userInfo = new HashMap<String, Object>();
                        userInfo.put("backup_key_uid", backupKeyUid);
                        userInfo.put("version", version);
                        userInfo.put("encrypted_content", macedEncryptedBackup);
                        this.notificationPostingDelegate.postNotification("backup_notification_backup_for_export_finished", userInfo);
                    }
                    userInfo = new HashMap();
                    userInfo.put("backup_key_uid", backupKeyUid);
                    userInfo.put("version", version);
                    userInfo.put("encrypted_content", macedEncryptedBackup);
                    this.notificationPostingDelegate.postNotification("backup_notification_backup_finished", userInfo);
                }
            }
            catch (Exception e) {
                Logger.x(e);
                this.backupFailed(tag, backupKeyUid, version);
            }
        });
    }

    @Override
    public ObvBackupKeyInformation getBackupKeyInformation() throws Exception {
        try (BackupManagerSession backupManagerSession = this.getSession();){
            BackupKey[] backupKeys = BackupKey.getAll(backupManagerSession);
            if (backupKeys.length == 0) {
                Logger.d("No BackupKey generated!");
                ObvBackupKeyInformation obvBackupKeyInformation = null;
                return obvBackupKeyInformation;
            }
            if (backupKeys.length > 1) {
                Logger.e("Multiple BackupKey generated, this should never occur!");
                ObvBackupKeyInformation obvBackupKeyInformation = null;
                return obvBackupKeyInformation;
            }
            BackupKey backupKey = backupKeys[0];
            Backup exportedBackup = backupKey.getExportedBackup();
            Backup uploadedBackup = backupKey.getUploadedBackup();
            ObvBackupKeyInformation obvBackupKeyInformation = new ObvBackupKeyInformation(backupKey.getKeyGenerationTimestamp(), backupKey.getLastSuccessfulKeyVerificationTimestamp(), backupKey.getSuccessfulVerificationCount(), exportedBackup == null ? 0L : exportedBackup.getStatusChangeTimestamp(), uploadedBackup == null ? 0L : uploadedBackup.getStatusChangeTimestamp());
            return obvBackupKeyInformation;
        }
    }

    @Override
    public void markBackupExported(UID backupKeyUid, int version) {
        try (BackupManagerSession backupManagerSession = this.getSession();){
            BackupKey backupKey = BackupKey.get(backupManagerSession, backupKeyUid);
            if (backupKey == null) {
                return;
            }
            Backup backup = Backup.get(backupManagerSession, backupKeyUid, version);
            if (backup == null || backup.getStatus() != 1 || !backup.isForExport()) {
                return;
            }
            backupManagerSession.session.startTransaction();
            backup.setUploadedOrExported();
            if (backupKey.getExportedBackupVersion() == null || backupKey.getExportedBackupVersion() < version) {
                backupKey.setExportedBackupVersion(version);
            }
            backupManagerSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void markBackupUploaded(UID backupKeyUid, int version) {
        try (BackupManagerSession backupManagerSession = this.getSession();){
            BackupKey backupKey = BackupKey.get(backupManagerSession, backupKeyUid);
            if (backupKey == null) {
                return;
            }
            Backup backup = Backup.get(backupManagerSession, backupKeyUid, version);
            if (backup == null || backup.getStatus() != 1 && backup.getStatus() != 2) {
                return;
            }
            backupManagerSession.session.startTransaction();
            backup.setUploadedOrExported();
            if (backupKey.getUploadedBackupVersion() == null || backupKey.getUploadedBackupVersion() < version) {
                backupKey.setUploadedBackupVersion(version);
            }
            backupManagerSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void discardBackup(UID backupKeyUid, int version) {
        try (BackupManagerSession backupManagerSession = this.getSession();){
            BackupKey backupKey = BackupKey.get(backupManagerSession, backupKeyUid);
            if (backupKey == null) {
                return;
            }
            Backup backup = Backup.get(backupManagerSession, backupKeyUid, version);
            if (backup == null || backup.getStatus() != 1) {
                return;
            }
            backup.setFailed();
            Logger.d("Backup discarded.");
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public int validateBackupSeed(String seedString, byte[] backupContent) {
        try {
            byte[] expectedMacOutput;
            byte[] ciphertext;
            BackupSeed backupSeed = new BackupSeed(seedString);
            BackupSeed.DerivedKeys derivedKeys = backupSeed.deriveKeys();
            if (derivedKeys == null) {
                return 3;
            }
            MAC mac = Suite.getMAC(derivedKeys.macKey);
            if (!mac.verify(derivedKeys.macKey, ciphertext = Arrays.copyOfRange(backupContent, 0, backupContent.length - mac.outputLength()), expectedMacOutput = Arrays.copyOfRange(backupContent, backupContent.length - mac.outputLength(), backupContent.length))) {
                return 3;
            }
            PublicKeyEncryption publicKeyEncryption = Suite.getPublicKeyEncryption(derivedKeys.encryptionKeyPair.getPrivateKey());
            publicKeyEncryption.decrypt(derivedKeys.encryptionKeyPair.getPrivateKey(), new EncryptedBytes(ciphertext));
            return 0;
        }
        catch (BackupSeed.SeedTooShortException e) {
            return 1;
        }
        catch (BackupSeed.SeedTooLongException e) {
            return 2;
        }
        catch (Exception e) {
            return 3;
        }
    }

    /*
     * Exception decompiling
     */
    private BackupContentAndDerivedKeys decryptBackupContent(String seedString, byte[] backupContent, ObjectMapper jsonObjectMapper) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ObvIdentity[] restoreOwnedIdentitiesFromBackup(String seedString, byte[] backupContent, String deviceDisplayName) {
        try {
            BackupContentAndDerivedKeys backupContentAndDerivedKeys = this.decryptBackupContent(seedString, backupContent, this.jsonObjectMapper);
            if (backupContentAndDerivedKeys == null) {
                return null;
            }
            if (backupContentAndDerivedKeys.pojo.backup_json_version != 0) {
                Logger.e("Restoring ownedIdentity with a different backup JSON version:" + backupContentAndDerivedKeys.pojo.backup_json_version + " (expecting 0).");
                return null;
            }
            try (BackupManagerSession backupManagerSession = this.getSession();){
                if (BackupKey.getAll(backupManagerSession).length == 0) {
                    BackupKey backupKey = BackupKey.create(backupManagerSession, backupContentAndDerivedKeys.derivedKeys.backupKeyUid, backupContentAndDerivedKeys.derivedKeys.encryptionKeyPair.getPublicKey(), backupContentAndDerivedKeys.derivedKeys.macKey);
                    backupKey.addSuccessfulVerification();
                    backupManagerSession.session.commit();
                }
            }
            return this.identityDelegate.restoreOwnedIdentitiesFromBackup(backupContentAndDerivedKeys.pojo.engine.identity_manager, deviceDisplayName, this.prng);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public void restoreContactsAndGroupsFromBackup(String seedString, byte[] backupContent, ObvIdentity[] restoredOwnedIdentities) {
        try {
            BackupContentAndDerivedKeys backupContentAndDerivedKeys = this.decryptBackupContent(seedString, backupContent, this.jsonObjectMapper);
            if (backupContentAndDerivedKeys == null) {
                return;
            }
            if (backupContentAndDerivedKeys.pojo.backup_json_version != 0) {
                Logger.e("Restoring contacts and groups with a different backup JSON version:" + backupContentAndDerivedKeys.pojo.backup_json_version + " (expecting 0).");
                return;
            }
            this.identityDelegate.restoreContactsAndGroupsFromBackup(backupContentAndDerivedKeys.pojo.engine.identity_manager, restoredOwnedIdentities, backupContentAndDerivedKeys.pojo.backup_timestamp);
            this.notificationPostingDelegate.postNotification("backup_notification_backup_restoration_finished", Collections.emptyMap());
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    public String decryptAppDataBackup(String seedString, byte[] backupContent) {
        try {
            BackupContentAndDerivedKeys backupContentAndDerivedKeys = this.decryptBackupContent(seedString, backupContent, this.jsonObjectMapper);
            if (backupContentAndDerivedKeys == null) {
                return null;
            }
            if (backupContentAndDerivedKeys.pojo != null) {
                return backupContentAndDerivedKeys.pojo.app;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(String notificationName, Map<String, Object> userInfo) {
        switch (notificationName) {
            case "identity_manager_notification_database_content_changed": {
                if (!this.autoBackupEnabled) break;
                this.scheduleBackupForUploadIfNeeded(false);
                break;
            }
            case "backup_notification_device_backup_needed": {
                if (!this.deviceBackupsActive) break;
                long targetTimestamp = System.currentTimeMillis() + 300000L;
                Set<ScheduledBackup> set = this.scheduledBackups;
                synchronized (set) {
                    boolean doBackup = true;
                    for (ScheduledBackup scheduledBackup : this.scheduledBackups) {
                        if (scheduledBackup.ownedIdentity != null) continue;
                        if (scheduledBackup.timestamp >= targetTimestamp) break;
                        doBackup = false;
                        break;
                    }
                    if (doBackup) {
                        try (BackupManagerSession backupManagerSession = this.getSession();){
                            DeviceBackupSeed deviceBackupSeed = DeviceBackupSeed.getActive(backupManagerSession);
                            if (deviceBackupSeed != null && deviceBackupSeed.getNextBackupTimestamp() > targetTimestamp) {
                                deviceBackupSeed.setNextBackupTimestamp(targetTimestamp);
                                backupManagerSession.session.commit();
                                this.scheduleDeviceBackup(targetTimestamp);
                            }
                        }
                        catch (Exception e) {
                            Logger.x(e);
                        }
                    }
                    break;
                }
            }
            case "backup_notification_profile_backup_needed": {
                Identity ownedIdentity;
                if (!this.deviceBackupsActive || (ownedIdentity = (Identity)userInfo.get("owned_identity")) == null) break;
                long targetTimestamp = System.currentTimeMillis() + 300000L;
                Set<ScheduledBackup> set = this.scheduledBackups;
                synchronized (set) {
                    boolean doBackup = true;
                    for (ScheduledBackup scheduledBackup : this.scheduledBackups) {
                        if (!ownedIdentity.equals(scheduledBackup.ownedIdentity)) continue;
                        if (scheduledBackup.timestamp >= targetTimestamp) break;
                        doBackup = false;
                        break;
                    }
                    if (doBackup) {
                        try (BackupManagerSession backupManagerSession = this.getSession();){
                            ProfileBackupThreadId profileBackupThreadId = ProfileBackupThreadId.get(backupManagerSession, ownedIdentity);
                            if (profileBackupThreadId == null || profileBackupThreadId.getNextBackupTimestamp() > targetTimestamp) {
                                if (profileBackupThreadId != null) {
                                    profileBackupThreadId.setNextBackupTimestamp(targetTimestamp);
                                    backupManagerSession.session.commit();
                                }
                                this.scheduleProfileBackup(ownedIdentity, targetTimestamp);
                            }
                        }
                        catch (Exception e) {
                            Logger.x(e);
                        }
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleBackupForUploadIfNeeded(boolean immediately) {
        Object object = this.autoBackupSchedulerLock;
        synchronized (object) {
            if (immediately) {
                if (this.autoBackupIsScheduled && this.scheduledAutoBackupTask != null) {
                    this.scheduledAutoBackupTask.cancel(true);
                    this.scheduledAutoBackupTask = null;
                }
                Logger.d("Immediately running a backup upload to the cloud");
                this.autoBackupScheduler.submit(() -> this.initiateBackup(false));
            } else {
                if (this.autoBackupIsScheduled) {
                    return;
                }
                Logger.d("Scheduling a backup upload to the cloud");
                this.autoBackupIsScheduled = true;
                this.scheduledAutoBackupTask = this.autoBackupScheduler.schedule(() -> {
                    Object object = this.autoBackupSchedulerLock;
                    synchronized (object) {
                        this.autoBackupIsScheduled = false;
                        this.scheduledAutoBackupTask = null;
                    }
                    this.initiateBackup(false);
                }, 120000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private static final class ScheduledBackup {
        final Identity ownedIdentity;
        final long timestamp;
        int failedAttemptCounts;
        long scheduledTimestamp;

        public ScheduledBackup(Identity ownedIdentity, long timestamp) {
            this.ownedIdentity = ownedIdentity;
            this.timestamp = timestamp;
            this.failedAttemptCounts = 0;
            this.scheduledTimestamp = timestamp;
        }

        void rescheduleAfterRetriableFailure() {
            ++this.failedAttemptCounts;
            long base = 250L << Math.min(this.failedAttemptCounts, 32);
            this.scheduledTimestamp = System.currentTimeMillis() + (long)((float)base * (1.0f + new Random().nextFloat()));
        }

        void clearFailedAttemptCounts() {
            this.failedAttemptCounts = 0;
            this.scheduledTimestamp = this.timestamp;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ScheduledBackup)) {
                return false;
            }
            ScheduledBackup o = (ScheduledBackup)obj;
            return this.timestamp == o.timestamp && Objects.equals(this.ownedIdentity, o.ownedIdentity);
        }

        public int hashCode() {
            if (this.ownedIdentity == null) {
                return Long.hashCode(this.timestamp);
            }
            return this.ownedIdentity.hashCode() * 31 + Long.hashCode(this.timestamp);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Pojo_0 {
        public EnginePojo_0 engine;
        public String app;
        public int backup_json_version;
        public long backup_timestamp;

        private Pojo_0() {
        }
    }

    private static class BackupContentAndDerivedKeys {
        private final Pojo_0 pojo;
        private final BackupSeed.DerivedKeys derivedKeys;

        public BackupContentAndDerivedKeys(Pojo_0 pojo, BackupSeed.DerivedKeys derivedKeys) {
            this.pojo = pojo;
            this.derivedKeys = derivedKeys;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class EnginePojo_0 {
        public String identity_manager;

        private EnginePojo_0() {
        }
    }

    private static final class UidAndVersion {
        public final UID uid;
        public final int version;

        public UidAndVersion(UID uid, int version) {
            this.uid = uid;
            this.version = version;
        }

        public int hashCode() {
            return this.uid.hashCode() * 31 + this.version;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UidAndVersion)) {
                return false;
            }
            UidAndVersion o = (UidAndVersion)obj;
            return Objects.equals(this.uid, o.uid) && this.version == o.version;
        }
    }
}

