/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.start_up;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import io.olvid.windows.messenger.FXApp;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.configuration.AppConfiguration;
import io.olvid.windows.messenger.configuration.AppDatabaseConfiguration;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.management.DbMigration;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.manager.BackupManager;
import io.olvid.windows.messenger.engine.service.MessageExpirationService;
import io.olvid.windows.messenger.fx.notifications.NotificationCenter;
import io.olvid.windows.messenger.fx.scenes_management.AppScenesManager;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.cache.UnreadMessageCountCache;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Watches;
import io.olvid.windows.messenger.misc.cache.ApplicationSettingsDatabaseCache;
import io.olvid.windows.messenger.misc.io.IOUtils;
import io.olvid.windows.messenger.misc.network.OuroborosKillerProxySelector;
import io.olvid.windows.messenger.misc.network.tcp.ClientSocketUtils;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.TcpServerNC;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UtilityNC;
import io.olvid.windows.messenger.misc.startupJob.StartupJobExecutor;
import java.awt.SystemTray;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.ProxySelector;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class AppRuntimeHelper {
    public static final String OLVID_DOWNLOAD_PAGE_URL = "https://olvid.io/download/en/";
    private static final String WORKING_DIR_NAME = "data";
    private static final String JFX_CACHE_DIR_JVM_OPTION_KEY = "javafx.cachedir";
    private static final String JNA_LIB_PATH_JVM_OPTION_KEY = "jna.boot.library.path";
    private static final String JNA_NO_UNPACK_JVM_OPTION_KEY = "jna.nounpack";
    private static final String JNA_NO_SYS_JVM_OPTION_KEY = "jna.nosys";
    private static final String SQLITE_LIB_PATH_JVM_OPTION_KEY = "org.sqlite.lib.path";
    private static final String SQLITE_LIB_NAME_JVM_OPTION_KEY = "org.sqlite.lib.name";
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase();
    public static final String USER_HOME_DIR_ABSOLUTE_PATH = System.getProperty("user.home");
    public static final String JAVA_HOME_ABSOLUTE_PATH = System.getProperty("java.home");
    public static final String JRE_DIR_ABSOLUTE_PATH = System.getProperty("java.home");
    public static final String XDG_DATA_HOME = System.getenv("XDG_DATA_HOME");
    public static final String XDG_FALLBACK_APPS_DATA_DIR = USER_HOME_DIR_ABSOLUTE_PATH + File.separator + ".local" + File.separator + "share";
    public static final String LAUNCH_DIR_ABSOLUTE_PATH = System.getProperty("user.dir");
    public static final boolean isPackaged = Boolean.parseBoolean(System.getProperty("olvid.packaged"));
    public static final boolean isDebugMode = Boolean.parseBoolean(System.getProperty("olvid.debug"));
    public static final boolean isMultiUser = Boolean.parseBoolean(System.getProperty("olvid.multiuser"));
    public static final boolean isDevMode = Boolean.parseBoolean(System.getProperty("olvid.dev"));
    public static final boolean isDataBaseEncrypted = Boolean.parseBoolean(System.getProperty("olvid.sqlcipher"));
    public static final String appVersion = System.getProperty("olvid.version");
    public static final String JRE_TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String BIN_DIR_NAME = "bin";
    private static final String LIB_DIR_NAME = "lib";
    private static final String JFX_CACHE_RELATIVE_PATH = ".openjfx" + File.separator + "cache";
    private static final String SQLCIPHER_LIB_NAME = "sqlcipher-jdbc";
    public static final String OLVID_LOG_FILE_DIR_JVM_OPTION_KEY = "olvid.logFileDir";
    public static SupportedPlatform platform;
    public static String OLVID_DATA_DIR_ABSOLUTE_PATH;
    private static final String LOG_DIR = "logs";
    static final String PORT_FILE = "port";
    private static final NotificationListener<? extends NotificationType> utilityNotificationsListener;
    public static final int buildVersion;
    public static final MutableLiveData<AppVersionInfo> appVersionInfo;
    public static boolean notifyNewVersion;
    static UtilityNC.UtilityNotificationEnumType[] subscribedUtilityNotificationsTypes;
    public static final Optional<Integer> watchLogDelay;
    private static final ScheduledExecutorService logExecutor;
    private static StartupMode startupModeCache;

    public static void initializeStaticConstants() {
        System.out.println("Static runtime initialization...");
        Objects.requireNonNull(OS_NAME);
        Objects.requireNonNull(USER_HOME_DIR_ABSOLUTE_PATH);
        if (AppRuntimeHelper.isWindows()) {
            platform = SupportedPlatform.WINDOWS;
        } else if (AppRuntimeHelper.isLinux()) {
            platform = SupportedPlatform.LINUX_DISTRIBUTION;
        } else if (AppRuntimeHelper.isMac()) {
            platform = SupportedPlatform.MACOS;
        } else {
            throw new IllegalStateException("AppRuntimeHelper::static Unrecognized Platform");
        }
        if (isPackaged && platform == SupportedPlatform.WINDOWS) {
            Objects.requireNonNull(JAVA_HOME_ABSOLUTE_PATH);
            System.setProperty(JNA_LIB_PATH_JVM_OPTION_KEY, JRE_DIR_ABSOLUTE_PATH + File.separator + BIN_DIR_NAME);
            System.setProperty(JNA_NO_UNPACK_JVM_OPTION_KEY, Boolean.toString(true));
            System.setProperty(JNA_NO_SYS_JVM_OPTION_KEY, Boolean.toString(true));
            System.setProperty(JFX_CACHE_DIR_JVM_OPTION_KEY, JRE_DIR_ABSOLUTE_PATH + File.separator + BIN_DIR_NAME + File.separator + JFX_CACHE_RELATIVE_PATH);
        }
        if (isDataBaseEncrypted) {
            AppRuntimeHelper.setSQLiteSystemProps();
        }
        OLVID_DATA_DIR_ABSOLUTE_PATH = AppRuntimeHelper.computeDataDir();
        String logFileDir = OLVID_DATA_DIR_ABSOLUTE_PATH + LOG_DIR;
        System.setProperty(OLVID_LOG_FILE_DIR_JVM_OPTION_KEY, logFileDir);
        AppLogger.reconfigureLog(AppConfiguration.getInstance().getConfigurationDir());
        ProxySelector.setDefault(new OuroborosKillerProxySelector(ProxySelector.getDefault()));
        System.setProperty("javax.accessibility.assistive_technologies", "");
        notifyNewVersion = AppConfiguration.getInstance().getNotifyOnUpdateProperty();
        AppLogger.init(FXApp.class);
        System.out.println("sqlcipher : " + isDataBaseEncrypted);
        System.out.println("dev : " + isDevMode);
        System.out.println("version : " + appVersion);
        System.out.println("Data dir path  -> " + OLVID_DATA_DIR_ABSOLUTE_PATH);
        System.out.println("launch dir abs path-> " + LAUNCH_DIR_ABSOLUTE_PATH);
        System.out.println("JRE abs path  -> " + JRE_DIR_ABSOLUTE_PATH);
        System.out.println("jna.boot.library.path  -> " + System.getProperty(JNA_LIB_PATH_JVM_OPTION_KEY));
        System.out.println("javafx.cachedir -> " + System.getProperty(JFX_CACHE_DIR_JVM_OPTION_KEY));
        System.out.println("org.sqlite.lib.path  -> " + System.getProperty(SQLITE_LIB_PATH_JVM_OPTION_KEY));
        System.out.println("org.sqlite.lib.name  -> " + System.getProperty(SQLITE_LIB_NAME_JVM_OPTION_KEY));
    }

    public static void closeBackgroundComponents() {
        EngineWrapper.getInstance().clearEngine();
        DbManager.clearConnections();
        AsyncTaskExecutor.shutdownNow();
    }

    public static void initializeBackgroundComponents(boolean isHeadless, boolean backgroundMode) {
        try {
            if (!(IOUtils.createDir(OLVID_DATA_DIR_ABSOLUTE_PATH + "tmp") && IOUtils.createDir(OLVID_DATA_DIR_ABSOLUTE_PATH + "fyles") && IOUtils.createDir(OLVID_DATA_DIR_ABSOLUTE_PATH + "thumbnails") && IOUtils.createDir(OLVID_DATA_DIR_ABSOLUTE_PATH + LOG_DIR))) {
                AppLogger.e("Couldn't create working dirs for application...Exiting sadly sniff ");
                System.exit(1);
            }
            DbMigration dbMigration = new DbMigration();
            dbMigration.performMigration();
            dbMigration.dispose();
            DbManager.getInstance();
            DbManager.getInstance().vacuumDatabase();
            UnreadMessageCountCache.getInstance().initialize();
            NCRegistry.registerNotificationCenter(NCRegistry.NCTypes.UTILITY_NC);
            NCRegistry.getUtilityNC().subscribe(subscribedUtilityNotificationsTypes, utilityNotificationsListener);
            EngineWrapper.getInstance().init(AppRuntimeHelper::computeDataDir);
            EngineWrapper.getInstance().getEngineInstance().vacuumDatabase();
            Api.getLifecycleApi().startNetworkJobsCoordinators();
            new StartupJobExecutor().run();
            BackupManager.getInstance();
            SelectedOwnedIdentitySingleton.getInstance();
            MessageExpirationService.getInstance();
            KeycloakManager.getInstance().init();
            DbManager.getInstance().getMessageRefDao().cleanUnreferencedMessageRef();
            KeycloakManager.synchronizeAllManagedIdentities();
            if (!isHeadless) {
                DbCache.getInstance();
                NotificationCenter.getInstance();
                ApplicationSettingsDatabaseCache.getInstance();
                NCRegistry.registerNotificationCenter(NCRegistry.NCTypes.UI_ACTION_NC);
                if (backgroundMode) {
                    AppScenesManager.globalAppStateContext.pushState(new AppScenesManager.GlobalAppState(AppScenesManager.AppStateType.RUNNING_BACKGROUND));
                } else {
                    AppScenesManager.globalAppStateContext.pushState(new AppScenesManager.GlobalAppState(AppScenesManager.AppStateType.RUNNING_FOREGROUND));
                }
            }
            if (watchLogDelay.isPresent()) {
                int logDelay = watchLogDelay.get();
                logExecutor.scheduleWithFixedDelay(() -> {
                    Watches.getInstance().print();
                    Watches.getInstance().clear();
                }, logDelay, logDelay, TimeUnit.MINUTES);
            }
        }
        catch (Exception e) {
            AppLogger.e("Cannot initialize background components, Please report", e);
            System.exit(1);
        }
    }

    public static boolean isWindows() {
        return OS_NAME.contains("win");
    }

    public static boolean isLinux() {
        return OS_NAME.contains("lin");
    }

    public static boolean isMac() {
        return OS_NAME.contains("mac");
    }

    public static void launchBrowser(String url) throws IOException, IllegalArgumentException {
        Objects.requireNonNull(url);
        String trimmedUrl = url.trim();
        if (trimmedUrl.isEmpty()) {
            throw new IllegalArgumentException("Empty url");
        }
        if (AppRuntimeHelper.isWindows()) {
            String quotedUrl = "\"" + trimmedUrl.replace("\"", "\\\"") + "\"";
            new ProcessBuilder("cmd", "/c", "start", "", quotedUrl).start();
            return;
        }
        if (AppRuntimeHelper.isMac()) {
            new ProcessBuilder("open", trimmedUrl).start();
            return;
        }
        if (AppRuntimeHelper.isLinux()) {
            new ProcessBuilder("xdg-open", trimmedUrl).start();
            return;
        }
    }

    public static TcpServerNC.TcpMessageNotificationEnumType getArgType(String arg) {
        TcpServerNC.TcpMessageNotificationEnumType toRet = TcpServerNC.TcpMessageNotificationEnumType.UNKNOWN;
        if (KeycloakUtils.isConfigurationUri(arg)) {
            toRet = TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_CONFIGURATION_URI;
        } else if (KeycloakUtils.isRedirectUri(arg)) {
            toRet = TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_AUTHENTICATION_REDIRECT_URI;
        }
        AppLogger.i("AppRuntimeHelper::getArgType found argtype -> " + toRet.name());
        return toRet;
    }

    public static boolean initiateTcpServerAndSavePort(FileChannel fc) throws IOException {
        AppLogger.i("AppRuntimeHelper::initiateTcpServerAndSavePort Starting tcp server....");
        NCRegistry.registerNotificationCenter(NCRegistry.NCTypes.TCP_SERVER_NC);
        if (NCRegistry.getTCPServerNC().startCenter()) {
            short port = (short)(NCRegistry.getTCPServerNC().getPort() == -1 ? 0 : NCRegistry.getTCPServerNC().getPort());
            ByteBuffer portBytes = ByteBuffer.allocate(2).putShort(port);
            portBytes.rewind();
            int w = fc.write(portBytes);
            if (w != portBytes.array().length) {
                throw new RuntimeException();
            }
            return true;
        }
        return false;
    }

    public static boolean writeArgToClientSocket(short port, TcpServerNC.TcpMessage arg) {
        block10: {
            boolean bl;
            block9: {
                Socket connectedTcpSocket = ClientSocketUtils.getBindedTcpSocket("127.0.0.1", port);
                try {
                    connectedTcpSocket.getOutputStream().write(EngineWrapper.getJsonObjectMapper().writeValueAsString((Object)arg).getBytes(StandardCharsets.UTF_8));
                    bl = true;
                    if (connectedTcpSocket == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (connectedTcpSocket != null) {
                            try {
                                connectedTcpSocket.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        AppLogger.e("Error in the json parsing before connect to server socket", (Exception)((Object)jsonProcessingException));
                        break block10;
                    }
                    catch (IOException ioException) {
                        AppLogger.e("Couldn't connect to server socket to share url...this is bad", ioException);
                    }
                }
                connectedTcpSocket.close();
            }
            return bl;
        }
        return false;
    }

    public static String[] removeElementFromArray(String[] array, Object element) {
        if (array.length > 1) {
            return new String[0];
        }
        if (array.length > 0) {
            int index = -1;
            for (int i = 0; i < array.length; ++i) {
                if (!array[i].equals(element)) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                String[] copy = (String[])Array.newInstance(String[].class.componentType(), array.length - 1);
                if (copy.length > 0) {
                    System.arraycopy(array, 0, copy, 0, index);
                    System.arraycopy(array, index + 1, copy, index, copy.length - index);
                }
                return copy;
            }
        }
        return array;
    }

    private static String computeDataDir() {
        Objects.requireNonNull(platform);
        Object dataDir = LAUNCH_DIR_ABSOLUTE_PATH;
        if (!isPackaged) {
            System.out.println("getDataDir() NOT PACKAGE CASE");
            dataDir = (String)dataDir + File.separator + WORKING_DIR_NAME + File.separator;
        } else {
            System.out.println("getDataDir() PACKAGED CASE");
            switch (platform.ordinal()) {
                case 0: {
                    dataDir = AppRuntimeHelper.getWindowsDataDirPath() + File.separator + WORKING_DIR_NAME + File.separator;
                    break;
                }
                case 1: {
                    if (XDG_DATA_HOME == null || XDG_DATA_HOME.isEmpty()) {
                        dataDir = XDG_FALLBACK_APPS_DATA_DIR + File.separator + "olvid" + File.separator;
                        break;
                    }
                    dataDir = XDG_DATA_HOME + File.separator + "olvid" + File.separator;
                    break;
                }
                case 2: {
                    dataDir = USER_HOME_DIR_ABSOLUTE_PATH + File.separator + WORKING_DIR_NAME + File.separator + "Library" + File.separator + "Application Support" + File.separator;
                }
            }
        }
        System.out.println("getDataDir() data dir path = " + (String)dataDir);
        return dataDir;
    }

    private static String getWindowsDataDirPath() {
        System.out.println("registriedGetStringValue: " + AppDatabaseConfiguration.getInstance().getDataDirRegistryKey());
        if (platform != SupportedPlatform.WINDOWS) {
            throw new IllegalStateException("Can't can't call this method on other platforms than Windows");
        }
        try {
            String registriedGetStringValue = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)AppDatabaseConfiguration.getInstance().getDataDirRegistryKey(), (String)"");
            System.out.println("registriedGetStringValue: " + registriedGetStringValue);
            return registriedGetStringValue;
        }
        catch (Win32Exception e) {
            if (isMultiUser) {
                System.out.println("registriedGetStringValue: NOT FOUND.... multiuser mode");
                return System.getenv("LOCALAPPDATA") + File.separator + "OlvidData";
            }
            System.out.println("registriedGetStringValue: NOT FOUND.... standalone mode");
            return JAVA_HOME_ABSOLUTE_PATH;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw unsatisfiedLinkError;
        }
    }

    private static StartupMode computeStartupMode() {
        if (!AppRuntimeHelper.isWindows()) {
            return StartupMode.NONE;
        }
        try {
            if (!Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run", (String)"Olvid")) {
                return StartupMode.NONE;
            }
            String cmd = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run", (String)"Olvid");
            if (cmd.endsWith("--background")) {
                return StartupMode.BACKGROUND;
            }
            return StartupMode.FOREGROUND;
        }
        catch (Exception e) {
            AppLogger.e("Unable to determine if Olvid is launched at startup", e);
            return StartupMode.NONE;
        }
    }

    public static synchronized StartupMode getStartupMode() {
        if (startupModeCache == null) {
            startupModeCache = AppRuntimeHelper.computeStartupMode();
        }
        return startupModeCache;
    }

    public static synchronized void setStartupLaunchMode(StartupMode mode) {
        try {
            switch (mode.ordinal()) {
                case 0: {
                    Advapi32Util.registryDeleteValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run", (String)"Olvid");
                    break;
                }
                case 1: 
                case 2: {
                    String parent = new File(JAVA_HOME_ABSOLUTE_PATH).getParent();
                    StringBuilder builder = new StringBuilder();
                    builder.append(parent).append("\\Olvid.exe");
                    if (mode == StartupMode.BACKGROUND) {
                        builder.append(" --background");
                    }
                    String cmd = builder.toString();
                    Advapi32Util.registrySetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run", (String)"Olvid", (String)cmd);
                }
            }
        }
        catch (Exception e) {
            AppLogger.e("Unable to set launch at startup value in registry", e);
        }
        startupModeCache = null;
    }

    private static void setSQLiteSystemProps() {
        String libDirPath = null;
        String libName = null;
        if (isDataBaseEncrypted) {
            switch (platform.ordinal()) {
                case 0: {
                    libDirPath = isPackaged ? JRE_DIR_ABSOLUTE_PATH + File.separator + BIN_DIR_NAME : LAUNCH_DIR_ABSOLUTE_PATH + File.separator + "libs/sqlcipher-jdbc/windows/x86_64";
                    libName = SQLCIPHER_LIB_NAME + SupportedPlatform.WINDOWS.sharedLibExtension;
                    break;
                }
                case 1: {
                    libDirPath = isPackaged ? JRE_DIR_ABSOLUTE_PATH + File.separator + LIB_DIR_NAME : (isDevMode ? LAUNCH_DIR_ABSOLUTE_PATH + File.separator + "libs/sqlcipher-jdbc/linux/x86_64" : LAUNCH_DIR_ABSOLUTE_PATH + File.separator + LIB_DIR_NAME + File.separator + "runtime" + File.separator + LIB_DIR_NAME);
                    libName = SQLCIPHER_LIB_NAME + SupportedPlatform.LINUX_DISTRIBUTION.sharedLibExtension;
                    break;
                }
                case 2: {
                    throw new IllegalStateException("AppRuntimeHelper::setLibDirPathInSystem libPath not handled on os :" + System.getProperty("os.name"));
                }
            }
        } else {
            throw new IllegalStateException("AppRuntimeHelper::setLibDirPathInSystem Can't call this method if database encryption property is not enabled");
        }
        System.out.println("SQLCIPHER lib abs path = " + libDirPath);
        System.setProperty(SQLITE_LIB_PATH_JVM_OPTION_KEY, libDirPath);
        System.setProperty(SQLITE_LIB_NAME_JVM_OPTION_KEY, libName);
    }

    private static int buildVersionFromAppVersion() {
        Objects.requireNonNull(appVersion);
        String[] versionParticules = appVersion.split("\\.");
        if (versionParticules.length != 3) {
            throw new IllegalStateException("AppRuntimeHelper::buildVersionFromAppVersion");
        }
        int buildVersion = Integer.parseInt(versionParticules[0]) * 10000;
        buildVersion += Integer.parseInt(versionParticules[1]) * 100;
        System.out.println("AppRuntimeHelper::buildVersionFromAppVersion build version = " + (buildVersion += Integer.parseInt(versionParticules[2])));
        return buildVersion;
    }

    public static boolean isBackgroundModeSupported() {
        if (!SystemTray.isSupported()) {
            return false;
        }
        return !AppRuntimeHelper.isLinux();
    }

    /*
     * Exception decompiling
     */
    private static void utilityNotificationListener(NotificationType notification) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=40,1138
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:632)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        utilityNotificationsListener = AppRuntimeHelper::utilityNotificationListener;
        buildVersion = AppRuntimeHelper.buildVersionFromAppVersion();
        appVersionInfo = new MutableLiveData();
        subscribedUtilityNotificationsTypes = new UtilityNC.UtilityNotificationEnumType[]{UtilityNC.UtilityNotificationEnumType.VERSION_DETECTED};
        watchLogDelay = Optional.of(2);
        logExecutor = Executors.newSingleThreadScheduledExecutor();
        startupModeCache = null;
    }

    public static enum SupportedPlatform {
        WINDOWS(".dll"),
        LINUX_DISTRIBUTION(".so"),
        MACOS(".dylib");

        public final String sharedLibExtension;

        private SupportedPlatform(String s) {
            this.sharedLibExtension = s;
        }
    }

    public static enum StartupMode {
        NONE,
        FOREGROUND,
        BACKGROUND;

    }

    public record AppVersionInfo(String currentAppVersion, boolean updateNeeded, int latestVersion, int minVersion, boolean updated, boolean outdated) {
        public static AppVersionInfo of(String currentAppVersion, boolean updateNeeded, int latestVersion, int minVersion, boolean updated, boolean outdated) {
            return new AppVersionInfo(currentAppVersion, updateNeeded, latestVersion, minVersion, updated, outdated);
        }
    }

    public static enum OlvidPlatforms {
        IPHONE,
        IPAD,
        MAC,
        ANDROID,
        WINDOWS,
        LINUX,
        BOT,
        UNKNOWN;

    }
}

