/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.state_pattern;

import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.misc.state_pattern.SimpleContext;
import java.util.LinkedList;

public class StackContext<S>
extends SimpleContext<S> {
    protected final LinkedList<S> statesHistory = new LinkedList();
    protected final MutableLiveData<Boolean> isStatesHistoryEmpty = new MutableLiveData<Boolean>(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushState(S newState) {
        LinkedList<S> linkedList = this.statesHistory;
        synchronized (linkedList) {
            int idx;
            if (this.currentState != null) {
                this.statesHistory.push(this.currentState);
                this.isStatesHistoryEmpty.postValue(false);
            }
            if ((idx = this.statesHistory.indexOf(newState)) != -1) {
                this.statesHistory.subList(0, idx + 1).clear();
            }
            this.currentState = newState;
            this.currentStateLiveData.postValue(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean goToPreviousState() {
        LinkedList<S> linkedList = this.statesHistory;
        synchronized (linkedList) {
            if (!this.statesHistory.isEmpty()) {
                this.currentState = this.statesHistory.pop();
                this.isStatesHistoryEmpty.postValue(this.statesHistory.isEmpty());
                this.currentStateLiveData.postValue(this.currentState);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replacePreviousState(S newState) {
        LinkedList<S> linkedList = this.statesHistory;
        synchronized (linkedList) {
            this.pushState(newState);
            if (!this.statesHistory.isEmpty()) {
                this.statesHistory.pop();
                this.isStatesHistoryEmpty.postValue(this.statesHistory.isEmpty());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean goToPreviousState(S targetState) {
        LinkedList<S> linkedList = this.statesHistory;
        synchronized (linkedList) {
            int pos;
            if (pos != -1) {
                for (pos = this.statesHistory.indexOf(targetState); pos >= 0; --pos) {
                    this.currentState = this.statesHistory.pop();
                }
                this.isStatesHistoryEmpty.postValue(this.statesHistory.isEmpty());
                this.currentStateLiveData.postValue(this.currentState);
                return true;
            }
        }
        return false;
    }

    public int indexOf(S state) {
        return this.statesHistory.indexOf(state);
    }

    public LiveData<Boolean> getIsStatesHistoryEmpty() {
        return this.isStatesHistoryEmpty;
    }

    public void updateLocalContext(S state, boolean clearContext) {
        Object finalState = this.getCurrentState();
        if (finalState != null && finalState.equals(state)) {
            this.clearContext();
        } else if (!this.goToPreviousState(state)) {
            if (clearContext) {
                this.clearContext();
            }
            this.pushState(state);
        }
    }

    public int getStackSize() {
        return this.statesHistory.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearContext() {
        LinkedList<S> linkedList = this.statesHistory;
        synchronized (linkedList) {
            this.statesHistory.clear();
        }
        this.currentState = null;
        this.currentStateLiveData.postValue(null);
        this.isStatesHistoryEmpty.postValue(true);
    }
}

