/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.state_pattern;

import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.state_pattern.IFlow;
import java.util.ArrayList;
import java.util.List;

public interface IFlowState<F extends IFlow<F>, T extends IFlowState<F, T>> {
    public List<Either<F, T>> getNextSteps();

    public boolean hasPrevious();

    default public boolean countSubFlowsAsRemainingSteps() {
        return true;
    }

    default public int getMaxRemainingSteps(List<Either<F, ?>> visitedSteps) {
        return this.getNonLoopingNextSteps(visitedSteps).stream().map(e -> {
            if (e.isLeft()) {
                return this.countSubFlowsAsRemainingSteps() ? 1 : 0;
            }
            if (!visitedSteps.contains(e)) {
                ArrayList toto = new ArrayList(visitedSteps);
                toto.add((Either<F, ?>)e);
                return 1 + ((IFlowState)e.getRight()).getMaxRemainingSteps(toto);
            }
            return 0;
        }).max(Integer::compareTo).orElse(0);
    }

    default public List<Either<F, T>> getNonLoopingNextSteps(List<Either<F, ?>> visitedSteps) {
        List<Either<F, T>> nextSteps = this.getNextSteps();
        ArrayList<Either<F, T>> list = new ArrayList<Either<F, T>>();
        for (Either<F, T> nextStep : nextSteps) {
            if (visitedSteps.contains(nextStep)) continue;
            list.add(nextStep);
        }
        return list;
    }
}

