/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.startupJob.jobs;

import io.olvid.windows.messenger.database.dao.attachment.AbstractAttachmentDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.attachment.AttachmentUtils;
import io.olvid.windows.messenger.misc.ImageUtils;
import java.util.HashMap;
import java.util.List;

public class DownloadDownloadableLinkPreviews
implements Runnable {
    @Override
    public void run() {
        this.run(DbManager.getInstance().getInboundAttachmentDao());
        this.run(DbManager.getInstance().getOwnedAttachmentDao());
    }

    private <Message extends AbstractUserMessageGenerated<Message>, Attachment extends ReceivedAttachmentGenerated<Attachment>> void run(AbstractAttachmentDao<Message, Attachment> attachmentDao) {
        HashMap<Id, Discussion> discussionMap = new HashMap<Id, Discussion>();
        HashMap<Id, OwnedIdentity> ownedIdentityMap = new HashMap<Id, OwnedIdentity>();
        List attachments = attachmentDao.getAll();
        for (ReceivedAttachmentGenerated attachment : attachments) {
            if (!ImageUtils.isLink(AttachmentUtils.getNonNullMimeType(attachment)) || attachment.getStatus() != ReceivedAttachmentGenerated.Status.DOWNLOADABLE) continue;
            Id<Discussion> discussionId = attachment.getDiscussionId();
            Discussion discussion = discussionMap.computeIfAbsent(discussionId, DbManager.getInstance().getDiscussionDao()::get);
            OwnedIdentity ownedIdentity = ownedIdentityMap.computeIfAbsent(discussion.getOwnedIdentityId(), DbManager.getInstance().getOwnedIdentityDao()::get);
            EngineWrapper.getInstance().downloadSmallAttachment(ownedIdentity.getBytesOwnedIdentity(), attachment.getEngineMessageIdentifier(), attachment.getIdx());
        }
    }
}

