/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.notification_pattern.notification_centers;

import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.fx.contacts.keycloak.KeycloakUserDetailsListItemData;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.GenericNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.RequestCardDisplayNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.AbstractNotificationCenter;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.util.Optional;

public class UIActionNC
extends AbstractNotificationCenter {
    private static final String UI_NOTIFICATION_EXECUTOR_NAME = "App-UINotificationExecutor";

    UIActionNC() {
        super(UI_NOTIFICATION_EXECUTOR_NAME);
        AppLogger.t("UINotificationCenter::UINotificationCenter()");
    }

    public static void fireGroupSelectedNotification(Optional<Id<Group>> groupId, boolean clearContextNeeded) {
        NCRegistry.getUIActionNC().postNotification(new RequestCardDisplayNotification<Id>(UserInteractionNotificationEnumType.GROUP_SELECTED, groupId.orElse(null), clearContextNeeded));
    }

    public static void fireContactSelectedNotification(Optional<Id<Contact>> contactId, boolean clearContextNeeded) {
        NCRegistry.getUIActionNC().postNotification(new RequestCardDisplayNotification<Id>(UserInteractionNotificationEnumType.CONTACT_SELECTED, contactId.orElse(null), clearContextNeeded));
    }

    public static void fireKeycloakSelectedNotification(Optional<KeycloakUserDetailsListItemData> keycloakUserOpt, boolean clearContextNeeded) {
        keycloakUserOpt.ifPresentOrElse(keycloakUser -> SelectedOwnedIdentitySingleton.getInstance().contactsInfoOfSelectedOwnedIdentity.getValue().stream().filter(contactInfo -> BytesKey.of(contactInfo.bytesContactIdentity()).equals(BytesKey.of(keycloakUser.identity))).findAny().ifPresentOrElse(contactInfo -> UIActionNC.fireContactSelectedNotification(Optional.of(contactInfo.genId()), clearContextNeeded), () -> NCRegistry.getUIActionNC().postNotification(new RequestCardDisplayNotification<KeycloakUserDetailsListItemData>(UserInteractionNotificationEnumType.KEYCLOAK_SELECTED, (KeycloakUserDetailsListItemData)keycloakUser, clearContextNeeded))), () -> NCRegistry.getUIActionNC().postNotification(new RequestCardDisplayNotification<Object>(UserInteractionNotificationEnumType.CONTACT_SELECTED, null, clearContextNeeded)));
    }

    public static void fireScrollToBottom(Id<Discussion> discussionId) {
        NCRegistry.getUIActionNC().postNotification(GenericNotification.of(UserInteractionNotificationEnumType.SCROLL_TO_BOTTOM, discussionId));
    }

    public static void fireRequestPageNotification(DiscussionViewModel.SearchedItem searchedItem) {
        NCRegistry.getUIActionNC().postNotification(RefreshCurrentSearchedItemNotification.of(searchedItem));
    }

    public static void fireNextSearchResultRequest() {
        NCRegistry.getUIActionNC().postNotification(NextSearchedItemRequestNotification.of());
    }

    public static void firePreviousSearchResultRequest() {
        NCRegistry.getUIActionNC().postNotification(PreviousSearchedItemRequestNotification.of());
    }

    public static enum UserInteractionNotificationEnumType implements NotificationType.NotificationEnumType
    {
        DISCUSSION_SELECTED,
        CONTACT_SELECTED,
        GROUP_SELECTED,
        GROUP_CARD_DISPLAYED_SUCCESSFULLY,
        CONTACT_CARD_DISPLAYED_SUCCESSFULLY,
        DISCUSSION_SELECTED_DISPLAYED_SUCCESSFULLY,
        DRAFT_ATTACHMENT_IMPORTED,
        OPEN_MODAL,
        MESSAGE_REPLY,
        KEYCLOAK_SELECTED,
        SCROLL_TO_BOTTOM,
        REFRESH_CURRENT_SEARCHED_ITEM,
        NEXT_SEARCHED_ITEM_REQUEST,
        PREVIOUS_SEARCHED_ITEM_REQUEST,
        KEEP_PINNED_IF_BOTTOM;

    }

    public record RefreshCurrentSearchedItemNotification(DiscussionViewModel.SearchedItem searchedItem) implements NotificationType
    {
        public static RefreshCurrentSearchedItemNotification of(DiscussionViewModel.SearchedItem searchedItem) {
            return new RefreshCurrentSearchedItemNotification(searchedItem);
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return UserInteractionNotificationEnumType.REFRESH_CURRENT_SEARCHED_ITEM;
        }
    }

    public record NextSearchedItemRequestNotification() implements NotificationType
    {
        public static NextSearchedItemRequestNotification of() {
            return new NextSearchedItemRequestNotification();
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return UserInteractionNotificationEnumType.NEXT_SEARCHED_ITEM_REQUEST;
        }
    }

    public record PreviousSearchedItemRequestNotification() implements NotificationType
    {
        public static PreviousSearchedItemRequestNotification of() {
            return new PreviousSearchedItemRequestNotification();
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return UserInteractionNotificationEnumType.PREVIOUS_SEARCHED_ITEM_REQUEST;
        }
    }
}

