/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.notification_pattern.notification_centers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.olvid.windows.messenger.misc.network.tcp.TcpServer;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.TcpMessageNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.AbstractNotificationCenter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class TcpServerNC
extends AbstractNotificationCenter {
    private static final String TCP_MESSAGE_NOTIFIER_THREAD_NAME = "App-TcpServerMessageNotifier";
    private final TcpServer tcpServer = new TcpServer(this::bytesReceived);
    private final ObjectMapper jsonObjectMapper = new JsonMapper();

    TcpServerNC() {
        super(TCP_MESSAGE_NOTIFIER_THREAD_NAME);
    }

    @Override
    public boolean startCenter() {
        return this.tcpServer.startServer() && super.startCenter();
    }

    @Override
    public void stopCenter() {
        this.tcpServer.stopServer();
    }

    public int getPort() {
        return this.tcpServer.getPort();
    }

    private void bytesReceived(byte[] receivedBytes) {
        try {
            String data = new String(receivedBytes, StandardCharsets.UTF_8);
            TcpMessage message = (TcpMessage)this.jsonObjectMapper.readValue(data, TcpMessage.class);
            this.logger.debug("TcpServerNC::bytesReceived message type :" + String.valueOf(TcpMessageNotificationEnumType.valueOf(message.messageType)));
            TcpMessageNotification tcpMessageNotification = new TcpMessageNotification(message.messageType, message.data);
            this.postNotification(tcpMessageNotification);
        }
        catch (JsonProcessingException decodingException) {
            this.logger.error("TcpServerMessageNotifier::bytesReceived Couldn't decode received bytes...", (Exception)((Object)decodingException));
        }
    }

    public static class TcpMessage {
        int messageType;
        String data;

        public TcpMessage() {
        }

        public TcpMessage(int messageType) {
            this(messageType, null);
        }

        public TcpMessage(int messageType, String data) {
            this.messageType = messageType;
            this.data = data;
        }

        @JsonProperty(value="type")
        public int getMessageType() {
            return this.messageType;
        }

        @JsonProperty(value="type")
        public void setMessageType(int messageType) {
            this.messageType = messageType;
        }

        @JsonProperty(value="secret")
        public String getData() {
            return this.data;
        }

        @JsonProperty(value="secret")
        public void setData(String data) {
            this.data = data;
        }
    }

    public static enum TcpMessageNotificationEnumType implements NotificationType.NotificationEnumType
    {
        NONE(0),
        KEYCLOAK_CONFIGURATION_URI(1),
        KEYCLOAK_AUTHENTICATION_REDIRECT_URI(2),
        UNKNOWN(-1);

        public final int messageId;
        private static final Map<Integer, TcpMessageNotificationEnumType> map;

        private TcpMessageNotificationEnumType(int messageId) {
            this.messageId = messageId;
        }

        public static TcpMessageNotificationEnumType valueOf(int id) {
            return map.get(id);
        }

        static {
            map = new HashMap<Integer, TcpMessageNotificationEnumType>();
            for (TcpMessageNotificationEnumType e : TcpMessageNotificationEnumType.values()) {
                map.put(e.messageId, e);
            }
        }
    }
}

