/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.notification_pattern.notification_centers;

import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public abstract class AbstractNotificationCenter {
    protected final BlockingQueue<NotificationType> notificationQueue;
    protected final Thread uiNotificationExecutor;
    protected final Map<NotificationType.NotificationEnumType, Set<NotificationListener<NotificationType>>> notificationConsumers;
    private static final int DEFAULT_BLOCKING_QUEUE_MAX_CAPACITY = 20;
    protected final AppLogger logger = new AppLogger(this.getClass());

    public AbstractNotificationCenter(String executorThreadName) {
        this.logger.debug("NotificationCenter::NotificationCenter() type : " + this.getClass().getName());
        this.notificationQueue = new ArrayBlockingQueue<NotificationType>(20);
        this.uiNotificationExecutor = new Thread(this::routine);
        this.uiNotificationExecutor.setName(executorThreadName);
        this.notificationConsumers = new HashMap<NotificationType.NotificationEnumType, Set<NotificationListener<NotificationType>>>();
    }

    public boolean startCenter() {
        try {
            if (!this.uiNotificationExecutor.isAlive()) {
                this.uiNotificationExecutor.start();
            }
            return true;
        }
        catch (Exception exception) {
            this.logger.error("Couldn't start notification center....", exception);
            return false;
        }
    }

    public void stopCenter() {
        try {
            this.uiNotificationExecutor.join(250L);
        }
        catch (InterruptedException e) {
            AppLogger.e("UINotificationCenter::shutdown : Interrupted while shutting down", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(NotificationType.NotificationEnumType userInteractionNotification, NotificationListener consumer) {
        Map<NotificationType.NotificationEnumType, Set<NotificationListener<NotificationType>>> map = this.notificationConsumers;
        synchronized (map) {
            this.notificationConsumers.putIfAbsent(userInteractionNotification, new HashSet());
            this.notificationConsumers.get(userInteractionNotification).add(consumer);
            AppLogger.t("UINotificationCenter::registerUINotificationConsumer() :Added consumer properly in set for notification : " + String.valueOf(userInteractionNotification));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(NotificationType.NotificationEnumType[] userInteractionNotifications, NotificationListener consumer) {
        Map<NotificationType.NotificationEnumType, Set<NotificationListener<NotificationType>>> map = this.notificationConsumers;
        synchronized (map) {
            for (NotificationType.NotificationEnumType userInteractionNotification : userInteractionNotifications) {
                this.notificationConsumers.putIfAbsent(userInteractionNotification, new HashSet());
                this.notificationConsumers.get(userInteractionNotification).add(consumer);
                AppLogger.t("UINotificationCenter::registerUINotificationConsumer() :Added consumer properly in set for notification : " + String.valueOf(userInteractionNotification));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribe(NotificationType.NotificationEnumType userInteractionNotification, NotificationListener<? extends NotificationType> consumer) {
        Map<NotificationType.NotificationEnumType, Set<NotificationListener<NotificationType>>> map = this.notificationConsumers;
        synchronized (map) {
            Set<NotificationListener<NotificationType>> consumers = this.notificationConsumers.get(userInteractionNotification);
            if (!consumers.remove(consumer)) {
                AppLogger.e("UINotificationCenter::unregisterUINotificationConsumer() : Couldn't remove consumer from set for notification : " + String.valueOf(userInteractionNotification));
                return;
            }
            AppLogger.t("UINotificationCenter::unregisterUINotificationConsumer() : Removed consumer properly from set for notification : " + String.valueOf(userInteractionNotification));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribe(NotificationType.NotificationEnumType[] userInteractionNotifications, NotificationListener<? extends NotificationType> consumer) {
        Map<NotificationType.NotificationEnumType, Set<NotificationListener<NotificationType>>> map = this.notificationConsumers;
        synchronized (map) {
            for (NotificationType.NotificationEnumType userInteractionNotification : userInteractionNotifications) {
                Set<NotificationListener<NotificationType>> consumers = this.notificationConsumers.get(userInteractionNotification);
                if (!consumers.remove(consumer)) {
                    AppLogger.e("UINotificationCenter::unregisterUINotificationConsumer() : Couldn't remove consumer from set for notification : " + String.valueOf(userInteractionNotification));
                    return;
                }
                AppLogger.t("UINotificationCenter::unregisterUINotificationConsumer() : Removed consumer properly from set for notification : " + String.valueOf(userInteractionNotification));
            }
        }
    }

    public void postNotification(NotificationType notification) {
        try {
            if (notification == null) {
                AppLogger.d("UINotificationCenter::postNotification : Notification is null, 0 notification posted");
                return;
            }
            this.notificationQueue.put(notification);
        }
        catch (InterruptedException e) {
            AppLogger.e("UINotificationCenter::postNotification : Interrupted while putting notification in queue", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void routine() {
        while (true) {
            try {
                block6: while (true) {
                    ArrayList consumers;
                    NotificationType uiNotification = this.notificationQueue.take();
                    Object object = this.notificationConsumers;
                    synchronized (object) {
                        consumers = new ArrayList(this.notificationConsumers.containsKey(uiNotification.getNotificationType()) ? (Collection)this.notificationConsumers.get(uiNotification.getNotificationType()) : new ArrayList());
                    }
                    object = consumers.iterator();
                    while (true) {
                        if (!object.hasNext()) continue block6;
                        NotificationListener consumer = (NotificationListener)object.next();
                        consumer.onReceived(uiNotification);
                    }
                    break;
                }
            }
            catch (Exception e) {
                AppLogger.e("UINotificationCenter::routine() : Interrupted while taking notification from queue", e);
                continue;
            }
            break;
        }
    }
}

