/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.network;

import io.olvid.engine.Logger;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.misc.network.VerifySSLConnectionCertificatesTask;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CustomSSLSocketFactory
extends SSLSocketFactory
implements HandshakeCompletedListener {
    private final SSLSocketFactory sslSocketFactory;
    public static final String[] ENABLED_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2"};
    public static final String[] ENABLED_CIPHER_SUITES = new String[]{"TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"};

    public CustomSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.configureSocket(this.sslSocketFactory.createSocket());
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.configureSocket(this.sslSocketFactory.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.configureSocket(this.sslSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.configureSocket(this.sslSocketFactory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.configureSocket(this.sslSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.configureSocket(this.sslSocketFactory.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        try {
            Logger.d((String)("Connected to " + event.getSocket().getInetAddress().getHostName() + " using cipher suite " + event.getCipherSuite()));
            String hostname = event.getSocket().getInetAddress().getHostName();
            Certificate[] certificates = event.getPeerCertificates();
            AsyncTaskExecutor.submitTask(new VerifySSLConnectionCertificatesTask(hostname, certificates));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Socket configureSocket(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setEnabledProtocols(ENABLED_PROTOCOLS);
            sslSocket.setEnabledCipherSuites(ENABLED_CIPHER_SUITES);
            sslSocket.addHandshakeCompletedListener(this);
        }
        return socket;
    }
}

