/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.cache;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.misc.Result;
import io.olvid.windows.messenger.misc.cache.LruCache;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;

public class FutureLruCache<Key, Success, Failure> {
    private final LruCache<Key, Future<Result<Success, Failure>>> lruCache;
    private final Map<Key, LinkedBlockingQueue<CompletionHandlers<Success, Failure>>> completionHandlers;

    public FutureLruCache(long cacheMaxSize) {
        this.lruCache = new LruCache(cacheMaxSize);
        this.completionHandlers = new ConcurrentHashMap<Key, LinkedBlockingQueue<CompletionHandlers<Success, Failure>>>();
    }

    public static <Key, Success, Failure> FutureLruCache<Key, Success, Failure> make(long cacheMaxSize) {
        return new FutureLruCache<Key, Success, Failure>(cacheMaxSize);
    }

    public boolean submitTask(Key key, Callable<Result<Success, Failure>> task) {
        return this.lruCache.computeIfAbsent(key, k -> {
            FutureTask futureTask = new FutureTask<Result<Success, Failure>>(task){

                @Override
                protected void done() {
                    super.done();
                    try {
                        FutureLruCache.this.executeCompletionHandlers(k, (Result)this.get());
                    }
                    catch (Exception e) {
                        FutureLruCache.this.executeCompletionHandlers(k, Result.failure(e));
                    }
                }
            };
            AsyncTaskExecutor.submitTask(futureTask);
            return futureTask;
        });
    }

    public boolean contains(Key key) {
        return this.lruCache.contains(key);
    }

    public boolean isDone(Key key) {
        Future<Result<Success, Failure>> future = this.lruCache.get(key);
        if (future == null) {
            return false;
        }
        return future.isDone();
    }

    public void asyncGet(Key key, Consumer<Result<Success, Failure>> completionHandler, Executor executor) {
        Future<Result<Success, Failure>> future = this.lruCache.get(key);
        if (future == null) {
            executor.execute(() -> completionHandler.accept(Result.failure(new NullPointerException())));
            return;
        }
        LinkedBlockingQueue queue = this.completionHandlers.computeIfAbsent(key, k -> new LinkedBlockingQueue());
        queue.add(new CompletionHandlers<Success, Failure>(completionHandler, executor));
        if (future.isDone()) {
            try {
                this.executeCompletionHandlers(key, future.get());
            }
            catch (Exception e) {
                this.executeCompletionHandlers(key, Result.failure(e));
            }
        }
    }

    public Result<Success, Failure> syncGet(Key key) {
        try {
            Future<Result<Success, Failure>> future = this.lruCache.get(key);
            if (future == null) {
                return Result.failure(new NullPointerException());
            }
            return future.get();
        }
        catch (Exception e) {
            return Result.failure(e);
        }
    }

    public Result<Success, Failure> blockingPut(Key key, Callable<Result<Success, Failure>> compute) {
        try {
            this.submitTask(key, compute);
            return this.lruCache.get(key).get();
        }
        catch (Exception e) {
            return Result.failure(e);
        }
    }

    public State getState(Key key) {
        if (!this.contains(key)) {
            return State.ABSENT;
        }
        if (!this.isDone(key)) {
            return State.COMPUTING;
        }
        return State.COMPUTED;
    }

    public void clear() {
        this.lruCache.forEach((key, future) -> future.cancel(true));
        this.lruCache.clear();
    }

    public void compute(Key key, Consumer<Result<Success, Failure>> onResult, Function<Key, Result<Success, Failure>> computeTask, Optional<BooleanProperty> isLoading) {
        switch (this.getState(key).ordinal()) {
            case 0: {
                isLoading.ifPresent(booleanProperty -> booleanProperty.set(true));
                this.submitTask(key, () -> (Result)computeTask.apply(key));
                break;
            }
            case 1: {
                isLoading.ifPresent(booleanProperty -> booleanProperty.set(true));
                break;
            }
            case 2: {
                isLoading.ifPresent(booleanProperty -> booleanProperty.set(false));
                Result<Success, Failure> result2 = this.syncGet(key);
                onResult.accept(result2);
                return;
            }
        }
        this.asyncGet(key, result -> {
            isLoading.ifPresent(booleanProperty -> booleanProperty.set(false));
            onResult.accept((Result)result);
        }, ViewControllerHelper.getUiUpdater());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.lruCache.forEach((key, future) -> builder.append(key).append(" -> ").append(future).append(System.lineSeparator()));
        return builder.toString();
    }

    private void executeCompletionHandlers(Key key, Result<Success, Failure> value) {
        LinkedBlockingQueue<CompletionHandlers<Success, Failure>> queue = this.completionHandlers.get(key);
        if (queue == null) {
            return;
        }
        ArrayList completionHandlers = new ArrayList();
        queue.drainTo(completionHandlers);
        if (completionHandlers.isEmpty()) {
            return;
        }
        for (CompletionHandlers completionHandler : completionHandlers) {
            Executor executor = completionHandler.executor();
            executor.execute(() -> completionHandler.consumer().accept(value));
        }
    }

    private record CompletionHandlers<Success, Failure>(Consumer<Result<Success, Failure>> consumer, Executor executor) {
    }

    public static enum State {
        ABSENT,
        COMPUTING,
        COMPUTED;

    }
}

