/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.cache;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.engine.atom.tasks.AtomTasks;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ApplicationSettingsDatabaseCache {
    private final Map<ApplicationSetting.GlobalAppSettings, String> data = Collections.synchronizedMap(new EnumMap(ApplicationSetting.GlobalAppSettings.class));
    private static ApplicationSettingsDatabaseCache instance;
    private final AppLogger logger = new AppLogger(this.getClass());

    ApplicationSettingsDatabaseCache() {
        this.logger.debug("ApplicationSettingsDatabaseCache::ApplicationSettingsDatabaseCache()");
        List<ApplicationSetting> applicationSettings = DbManager.getInstance().getApplicationSettingsDao().getAll();
        for (ApplicationSetting applicationSetting : applicationSettings) {
            this.data.put(applicationSetting.getPrefKey(), applicationSetting.getPrefValue());
        }
    }

    public static synchronized ApplicationSettingsDatabaseCache getInstance() {
        if (instance == null) {
            instance = new ApplicationSettingsDatabaseCache();
        }
        return instance;
    }

    public String get(ApplicationSetting.GlobalAppSettings key) {
        return this.data.get((Object)key);
    }

    public boolean getAsBoolean(ApplicationSetting.GlobalAppSettings key) {
        return Boolean.parseBoolean(this.data.get((Object)key));
    }

    public void set(ApplicationSetting.GlobalAppSettings key, String value) {
        if (value == null) {
            this.data.remove((Object)key);
        } else {
            this.data.put(key, value);
        }
        AsyncTaskExecutor.submitTask(() -> AtomTasks.updateApplicationSetting(key, Optional.ofNullable(value), true));
    }
}

