/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Watches {
    private static final AppLogger logger = new AppLogger(Watches.class);
    private static final Watches instance = new Watches();
    public Map<String, AtomicLong> totalTime = new ConcurrentHashMap<String, AtomicLong>();
    public Map<String, AtomicInteger> totalRun = new ConcurrentHashMap<String, AtomicInteger>();

    public static Watches getInstance() {
        return instance;
    }

    public Watch start(String name) {
        return new Watch(name, System.nanoTime());
    }

    public <T> Watch start(String name, List<Class<? extends T>> classes) {
        String name_ = name + String.valueOf(classes.stream().map(Class::getSimpleName).toList());
        return new Watch(name_, System.nanoTime());
    }

    private void stop(String name, long duration) {
        AtomicLong currentTotalTime = this.totalTime.computeIfAbsent(name, k -> new AtomicLong(0L));
        currentTotalTime.addAndGet(duration);
        AtomicInteger currentTotalRuns = this.totalRun.computeIfAbsent(name, k -> new AtomicInteger(0));
        currentTotalRuns.incrementAndGet();
    }

    public void clear() {
        this.totalTime.clear();
        this.totalRun.clear();
    }

    public void print() {
        ArrayList<Map.Entry<String, AtomicLong>> entries = new ArrayList<Map.Entry<String, AtomicLong>>(this.totalTime.entrySet());
        entries.sort(Comparator.comparingLong(e -> ((AtomicLong)e.getValue()).get()));
        logger.debug("");
        logger.debug("|NAME|TIME|RUN|AVG|");
        logger.debug("|----|----|---|---|");
        for (Map.Entry entry : entries) {
            StringBuilder builder = new StringBuilder("|");
            builder.append((String)entry.getKey()).append("|");
            builder.append(((AtomicLong)entry.getValue()).get() / 1000000L).append("ms|");
            AtomicInteger runs = this.totalRun.get(entry.getKey());
            builder.append(runs).append("|");
            double avg = (double)((AtomicLong)entry.getValue()).get() / (double)runs.get();
            builder.append(avg / 1000000.0).append("ms|");
            logger.debug(builder.toString());
        }
        logger.debug("");
    }

    public void printIfIsDevMode() {
        if (AppRuntimeHelper.isDevMode) {
            this.print();
        }
    }

    public record Watch(String name, long start) {
        public long stop() {
            long now = System.nanoTime();
            long duration = now - this.start;
            Watches.getInstance().stop(this.name, duration);
            return duration;
        }
    }
}

