/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class ThrottledConsumer {
    private final AppLogger logger = new AppLogger(this.getClass());
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final Consumer<Optional<String>> operation;
    private final String name;
    private final long delayMillis;
    private volatile Optional<String> lastArg = Optional.empty();
    private final AtomicLong lastRunTime = new AtomicLong(-1L);
    private final AtomicBoolean isQueued = new AtomicBoolean(false);
    private Optional<ScheduledFuture<?>> scheduledTask = Optional.empty();

    public ThrottledConsumer(Consumer<Optional<String>> operation, String name, long delayMillis) {
        this.operation = operation;
        this.name = name;
        this.delayMillis = delayMillis;
    }

    public void run(String arg) {
        long currentTime = System.currentTimeMillis();
        this.lastArg = Optional.ofNullable(arg);
        if (this.isQueued.get()) {
            this.logger.trace("ThrottledConsumer::run dropping %s because it is already queued", this.name);
        } else if (this.shouldRunNow(currentTime)) {
            this.lastRunTime.getAndSet(currentTime);
            this.logger.trace("ThrottledConsumer::run calling %s immediately", this.name);
            this.scheduledTask.ifPresent(scheduledFuture -> scheduledFuture.cancel(true));
            this.scheduledTask = Optional.of(this.scheduler.schedule(this::scheduledRun, 0L, TimeUnit.MILLISECONDS));
        } else {
            this.logger.trace("ThrottledConsumer::run  queueing %s to be called in %d ms", this.name, this.delayMillis);
            this.isQueued.getAndSet(true);
            this.scheduledTask = Optional.of(this.scheduler.schedule(this::scheduledRun, this.delayMillis, TimeUnit.MILLISECONDS));
        }
    }

    private void scheduledRun() {
        this.lastRunTime.getAndSet(System.currentTimeMillis());
        this.isQueued.getAndSet(false);
        this.operation.accept(this.lastArg);
    }

    private boolean shouldRunNow(long currentTime) {
        return this.lastRunTime.get() == -1L || this.lastRunTime.get() + this.delayMillis < currentTime;
    }

    public Optional<ScheduledFuture<?>> getScheduledTask() {
        return this.scheduledTask;
    }
}

