/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.misc.PositionsMapping;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final Pattern LINE_TERMINATOR = Pattern.compile("\r\n|\r|\n");
    private static final Pattern unAccentPattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final Pattern windowsReserved = Pattern.compile("^(?:CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\.[^.]*)*?$", 2);

    private StringUtils() {
    }

    public static String localizePlurals(String zero, String one, String multiple, long quantity) {
        MessageFormat messageFormat = new MessageFormat("{0}");
        ResourceBundle bundle = ViewControllerHelper.RESOURCE_BUNDLE;
        double[] limits = new double[]{0.0, 1.0, 2.0};
        String[] strings = new String[]{bundle.getString(zero), bundle.getString(one), bundle.getString(multiple)};
        messageFormat.setFormatByArgumentIndex(0, new ChoiceFormat(limits, strings));
        return messageFormat.format(new Object[]{quantity});
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty() || string.trim().isEmpty();
    }

    public static boolean isEmpty(Optional<String> string) {
        if (string.isEmpty()) {
            return true;
        }
        return StringUtils.isEmpty(string.get());
    }

    public static String ifEmptyThenNull(String string) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    public static String unAccent(CharSequence source) {
        return unAccentPattern.matcher(Normalizer.normalize(source, Normalizer.Form.NFD)).replaceAll("").toLowerCase(Locale.getDefault());
    }

    public static Optional<Character> firstChar(String s) {
        if (s == null || s.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(s.charAt(0)));
    }

    public static String sanitizeFilename(boolean isWindows, String filename) {
        Object name = filename;
        if (isWindows) {
            if (windowsReserved.matcher((CharSequence)(name = ((String)name).replaceAll("[:\\\\/*?|<>\\x00-\\x1F]", "_"))).matches()) {
                name = "_" + (String)name;
            }
            name = ((String)name).replaceAll("[. ]*$", "");
        } else {
            name = ((String)name).replaceAll("[/\\x00]", "_");
        }
        if (((String)name).length() > 255) {
            int extLen;
            int extIndex = ((String)name).indexOf(".");
            name = extIndex == -1 ? ((String)name).substring(0, 255) : ((extLen = ((String)name).length() - extIndex) > 255 ? ((String)name).substring(0, 255) : ((String)name).substring(0, 255 - extLen) + ((String)name).substring(extIndex));
        }
        return name;
    }

    public static boolean find(String input, List<Pattern> patterns) {
        String unAccented = StringUtils.normalize(input);
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(unAccented);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public static String normalize(CharSequence source) {
        return unAccentPattern.matcher(Normalizer.normalize(source, Normalizer.Form.NFKD)).replaceAll("").toLowerCase(Locale.getDefault());
    }

    public static List<HighlightRange> highlightString(String input, String searchText) {
        String[] words = searchText.trim().split("\\s+");
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String word : words) {
            if (word.trim().isEmpty()) continue;
            patterns.add(Pattern.compile(Pattern.quote(StringUtils.unAccent(word))));
        }
        String normalized = StringUtils.normalize(input);
        PositionsMapping positions = new PositionsMapping(input, EnumSet.allOf(PositionsMapping.Kind.class));
        BitSet highlighted = new BitSet(input.length());
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(normalized);
            while (matcher.find()) {
                int start = positions.getIndex(matcher.start(), true);
                int end = positions.getIndex(matcher.end(), false);
                highlighted.set(start, end);
            }
        }
        if (highlighted.isEmpty()) {
            return List.of();
        }
        ArrayList<HighlightRange> result = new ArrayList<HighlightRange>();
        int start = highlighted.nextSetBit(0);
        while (start != -1) {
            int end = highlighted.nextClearBit(start + 1);
            result.add(new HighlightRange(start, end));
            start = highlighted.nextSetBit(end);
        }
        return result;
    }

    public record HighlightRange(int start, int end) {
    }
}

