/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import java.util.Optional;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;

public class SimpleOptionalProperty<T>
extends SimpleObjectProperty<Optional<T>> {
    private IsEmptyProperty isEmpty;

    public SimpleOptionalProperty() {
        super(Optional.empty());
    }

    public ReadOnlyBooleanProperty isEmptyProperty() {
        if (this.isEmpty == null) {
            this.isEmpty = new IsEmptyProperty();
        }
        return this.isEmpty;
    }

    protected void fireValueChangedEvent() {
        super.fireValueChangedEvent();
        if (this.isEmpty != null) {
            this.isEmpty.fireValueChangedEvent();
        }
    }

    public ObservableValue<T> orElse2(T other) {
        return this.map(o -> o.orElse(other));
    }

    private class IsEmptyProperty
    extends ReadOnlyBooleanPropertyBase {
        private IsEmptyProperty() {
        }

        public boolean get() {
            return ((Optional)SimpleOptionalProperty.this.get()).isEmpty();
        }

        public Object getBean() {
            return SimpleOptionalProperty.this;
        }

        public String getName() {
            return "isEmpty";
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }
}

