/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class Result<Success, Failure> {
    public static <Success, Failure> Result<Success, Failure> success(Success value) {
        Objects.requireNonNull(value, "The value of a Result cannot be null");
        return new SuccessImpl(value);
    }

    public static <Success, Failure> Result<Success, Failure> failure(Failure failure) {
        Objects.requireNonNull(failure, "The failure of a Result cannot be null");
        return new FailureWithValueImpl(failure);
    }

    public static <Success, Failure> Result<Success, Failure> failure(Throwable throwable) {
        Objects.requireNonNull(throwable, "The failure of a Result cannot be null");
        return new FailureWithThrowableImpl(throwable);
    }

    public abstract boolean isSuccess();

    public abstract Success getSuccess();

    public abstract void ifSuccess(Consumer<? super Success> var1);

    public final boolean isFailure() {
        return !this.isSuccess();
    }

    public abstract Optional<Failure> getFailure();

    public abstract Optional<Throwable> getThrowable();

    public abstract Failure getFailureOrThrow() throws Throwable;

    public abstract void ifFailure(Runnable var1);

    public abstract <OtherSuccess> Result<OtherSuccess, Failure> map(Function<? super Success, ? extends OtherSuccess> var1);

    private static final class SuccessImpl<Success, Failure>
    extends Result<Success, Failure> {
        private final Success value;

        private SuccessImpl(Success value) {
            this.value = value;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public Success getSuccess() {
            return this.value;
        }

        @Override
        public void ifSuccess(Consumer<? super Success> action) {
            Objects.requireNonNull(action, "The value action cannot be null");
            action.accept(this.value);
        }

        @Override
        public Optional<Failure> getFailure() {
            throw new NoSuchElementException("Result contains a success: " + this.value.toString());
        }

        @Override
        public Failure getFailureOrThrow() throws Throwable {
            throw new NoSuchElementException("Result contains a success: " + this.value.toString());
        }

        @Override
        public Optional<Throwable> getThrowable() {
            throw new NoSuchElementException("Result contains a success: " + this.value.toString());
        }

        @Override
        public void ifFailure(Runnable action) {
        }

        @Override
        public <OtherSuccess> Result<OtherSuccess, Failure> map(Function<? super Success, ? extends OtherSuccess> mapper) {
            return Result.success(mapper.apply(this.value));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SuccessImpl success = (SuccessImpl)o;
            return Objects.equals(this.value, success.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static final class FailureWithValueImpl<Success, Failure>
    extends AbstractFailure<Success, Failure> {
        private final Failure failure;

        public FailureWithValueImpl(Failure failure) {
            this.failure = failure;
        }

        @Override
        public Optional<Failure> getFailure() {
            return Optional.of(this.failure);
        }

        @Override
        public Optional<Throwable> getThrowable() {
            return Optional.empty();
        }

        @Override
        public Failure getFailureOrThrow() throws Throwable {
            return this.failure;
        }

        @Override
        public <OtherSuccess> Result<OtherSuccess, Failure> map(Function<? super Success, ? extends OtherSuccess> mapper) {
            return Result.failure(this.failure);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailureWithValueImpl that = (FailureWithValueImpl)o;
            return Objects.equals(this.failure, that.failure);
        }

        public int hashCode() {
            return Objects.hash(this.failure);
        }
    }

    private static final class FailureWithThrowableImpl<Success, Failure>
    extends AbstractFailure<Success, Failure> {
        private final Throwable throwable;

        private FailureWithThrowableImpl(Throwable throwable) {
            this.throwable = throwable;
        }

        @Override
        public Optional<Failure> getFailure() {
            return Optional.empty();
        }

        @Override
        public Optional<Throwable> getThrowable() {
            return Optional.of(this.throwable);
        }

        @Override
        public Failure getFailureOrThrow() throws Throwable {
            throw this.throwable;
        }

        @Override
        public <OtherSuccess> Result<OtherSuccess, Failure> map(Function<? super Success, ? extends OtherSuccess> mapper) {
            return Result.failure(this.throwable);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailureWithThrowableImpl failure = (FailureWithThrowableImpl)o;
            return Objects.equals(this.throwable, failure.throwable);
        }

        public int hashCode() {
            return Objects.hash(this.throwable);
        }
    }

    private static abstract class AbstractFailure<Success, Failure>
    extends Result<Success, Failure> {
        private AbstractFailure() {
        }

        @Override
        public final boolean isSuccess() {
            return false;
        }

        @Override
        public final Success getSuccess() {
            throw new NoSuchElementException("Result contains a failure");
        }

        @Override
        public final void ifSuccess(Consumer<? super Success> action) {
        }

        @Override
        public final void ifFailure(Runnable action) {
            Objects.requireNonNull(action, "The value action cannot be null");
            action.run();
        }
    }
}

