/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.bmp.BmpHeaderDirectory;
import com.drew.metadata.gif.GifImageDirectory;
import com.drew.metadata.jpeg.JpegDirectory;
import com.drew.metadata.png.PngDirectory;
import io.olvid.windows.messenger.logger.AppLogger;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public final class ImageUtils {
    private static final Map<String, String> additionalMimeType = new HashMap<String, String>();
    private static final Pattern imagePattern = Pattern.compile("^(image)/.+");
    private static final Pattern videoPattern = Pattern.compile("^(video)/.+");
    private static final Pattern audioPattern = Pattern.compile("^(audio)/.+");

    private ImageUtils() {
    }

    private static Optional<Integer> tagValue(Iterable<Directory> directories, int tag) {
        for (Directory directory : directories) {
            if (!directory.containsTag(tag)) continue;
            try {
                return Optional.of(directory.getInt(tag));
            }
            catch (MetadataException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    private static <D extends Directory> Optional<D> getDirectory(Iterable<Directory> directories, Class<D> clazz) {
        for (Directory directory : directories) {
            if (!clazz.isInstance(directory)) continue;
            return Optional.of((Directory)clazz.cast(directory));
        }
        return Optional.empty();
    }

    private static Optional<ImageMetadata> extractImageMetadata(Iterable<Directory> directories) throws MetadataException {
        Optional<Integer> orientationOpt = ImageUtils.tagValue(directories, 274);
        Optional<Orientation> orientation = orientationOpt.map(Orientation::of);
        block6: for (MimeType mimeType : MimeType.values()) {
            switch (mimeType.ordinal()) {
                case 0: {
                    Optional<JpegDirectory> jpegDirectory = ImageUtils.getDirectory(directories, JpegDirectory.class);
                    if (!jpegDirectory.isPresent()) continue block6;
                    int width = jpegDirectory.get().getImageWidth();
                    int height = jpegDirectory.get().getImageHeight();
                    return Optional.of(new ImageMetadata(orientation, width, height));
                }
                case 1: {
                    Optional<BmpHeaderDirectory> bmpDirectory = ImageUtils.getDirectory(directories, BmpHeaderDirectory.class);
                    if (!bmpDirectory.isPresent()) continue block6;
                    int height = bmpDirectory.get().getInt(1);
                    int width = bmpDirectory.get().getInt(2);
                    return Optional.of(new ImageMetadata(orientation, width, Math.abs(height)));
                }
                case 2: {
                    Optional<PngDirectory> pngDirectory = ImageUtils.getDirectory(directories, PngDirectory.class);
                    if (!pngDirectory.isPresent()) continue block6;
                    int height = pngDirectory.get().getInt(2);
                    int width = pngDirectory.get().getInt(1);
                    return Optional.of(new ImageMetadata(orientation, width, height));
                }
                case 3: {
                    Optional<GifImageDirectory> gifDirectory = ImageUtils.getDirectory(directories, GifImageDirectory.class);
                    if (!gifDirectory.isPresent()) continue block6;
                    int height = gifDirectory.get().getInt(4);
                    int width = gifDirectory.get().getInt(3);
                    return Optional.of(new ImageMetadata(orientation, width, height));
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<ImageMetadata> getMetadata(InputStream inputStream) {
        try {
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)inputStream);
            Iterable directories = metadata.getDirectories();
            return ImageUtils.extractImageMetadata(directories);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static boolean isImage(String mimeType) {
        return imagePattern.matcher(mimeType).find();
    }

    public static boolean isLink(String mimeType) {
        return mimeType.equalsIgnoreCase("olvid/link-preview");
    }

    public static boolean isAudio(String mimeType) {
        return audioPattern.matcher(mimeType).find();
    }

    public static boolean isVideo(String mimeType) {
        return videoPattern.matcher(mimeType).find();
    }

    public static String getDefaultImage(String mimeType) {
        if (ImageUtils.isImage(mimeType)) {
            return "/images/thumbnails/placeholder.png";
        }
        if (ImageUtils.isVideo(mimeType)) {
            return "/images/thumbnails/video.png";
        }
        if (ImageUtils.isAudio(mimeType)) {
            return "/images/thumbnails/audio.png";
        }
        return "/images/thumbnails/file.png";
    }

    public static boolean isSupportedImage(String mimeType) {
        if (!ImageUtils.isImage(mimeType)) {
            return false;
        }
        Optional<MimeType> type = Arrays.stream(MimeType.values()).filter(mt -> mt.value.equals(mimeType)).findAny();
        if (type.isPresent()) {
            return true;
        }
        AppLogger.t("isSupportedImage: Mime type not handle: " + mimeType);
        return false;
    }

    public static enum MimeType {
        JPEG("image/jpeg"),
        BMP("image/bmp"),
        PNG("image/png"),
        GIF("image/gif");

        public final String value;

        private MimeType(String value) {
            this.value = value;
        }

        public String extension() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "jpg";
                case 1 -> "bmp";
                case 2 -> "png";
                case 3 -> "gif";
            };
        }

        public static Optional<MimeType> of(String value) {
            return Arrays.stream(MimeType.values()).filter(t -> t.value.equals(value)).findFirst();
        }
    }

    public record ImageMetadata(Optional<Orientation> orientation, int width, int height) {
    }

    public static enum Orientation {
        Undefined(0),
        Normal(1),
        FlipHorizontal(2),
        Rotate180(3),
        FlipVertical(4),
        Transpose(5),
        Rotate90(6),
        Transverse(7),
        Rotate270(8);

        final int tag;

        private Orientation(int tag) {
            this.tag = tag;
        }

        static Orientation of(int tag) {
            for (Orientation orientation : Orientation.values()) {
                if (orientation.tag != tag) continue;
                return orientation;
            }
            return Undefined;
        }

        public int rotation() {
            switch (this.ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    return 0;
                }
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
            }
            return 0;
        }
    }
}

